/*
 * Decompiled with CFR 0.152.
 */
package com.codoid.products.fillo;

import com.codoid.products.exception.FilloException;
import com.codoid.products.fillo.CommonExcelUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class SelectExcelUtil {
    public Map<String, Map> runSelectQuery(Object oConnection, String strQuery, String strTableName, ArrayList<String> columnNames, boolean isAllColumnRequired, boolean blWhereConditionApplicable, Map<String, Map<String, String>> whereConditionsMap) throws FilloException {
        int rowStart;
        LinkedHashMap<String, Map> mainMap = new LinkedHashMap<String, Map>();
        LinkedHashMap<String, Map<String, String>> recordsetMap = new LinkedHashMap<String, Map<String, String>>();
        HashMap<String, String> tableMap = new HashMap<String, String>();
        Row firstRow = null;
        int inRowCounter = 0;
        if (strTableName.equals("")) {
            throw new FilloException("Table Name is Missing - " + strQuery);
        }
        Workbook workbook = (Workbook)oConnection;
        FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
        Sheet sheet = workbook.getSheet(strTableName);
        if (sheet == null) {
            throw new FilloException(strTableName + " table is not found");
        }
        if (System.getProperty("ROW") == null) {
            rowStart = sheet.getFirstRowNum() + 1;
            firstRow = sheet.getRow(sheet.getFirstRowNum());
        } else {
            rowStart = Integer.parseInt(System.getProperty("ROW"));
            firstRow = sheet.getRow(rowStart - 1);
        }
        int rowEnd = sheet.getLastRowNum();
        int colStart = System.getProperty("COLUMN") == null ? 0 : Integer.parseInt(System.getProperty("COLUMN")) - 1;
        Map<String, String> columnNamesMap = CommonExcelUtil.getColumnNames(colStart, firstRow);
        tableMap.put("NAME", strTableName);
        mainMap.put("TABLE", tableMap);
        Map<String, String> realColumnNamesMap = null;
        if (isAllColumnRequired) {
            realColumnNamesMap = CommonExcelUtil.getRealColumnNames(colStart, firstRow);
        } else {
            realColumnNamesMap = new LinkedHashMap<String, String>();
            for (int index = 0; index <= columnNames.size() - 1; ++index) {
                realColumnNamesMap.put("" + index, columnNames.get(index));
            }
        }
        mainMap.put("COLS", realColumnNamesMap);
        if (columnNamesMap.size() == 0) {
            throw new FilloException("Table header are missing. Table Name:" + strTableName);
        }
        for (int rowNum = rowStart; rowNum <= rowEnd; ++rowNum) {
            try {
                Row row = sheet.getRow(rowNum);
                int inColumnCount = columnNamesMap.size() + colStart - 1;
                LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
                for (int inCol = colStart; inCol <= inColumnCount; ++inCol) {
                    String strColumnName = columnNamesMap.get("" + inCol).toString().toUpperCase();
                    Cell cell = row.getCell(inCol, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                    try {
                        evaluator.evaluate(cell);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (cell == null) {
                        rowMap.put(strColumnName, "");
                        continue;
                    }
                    String strValue = CommonExcelUtil.getCellValueAsString(cell.getCellType().ordinal(), cell);
                    rowMap.put(strColumnName, strValue);
                }
                if (blWhereConditionApplicable) {
                    if (!CommonExcelUtil.multileWhereConditions(rowMap, whereConditionsMap)) continue;
                    recordsetMap.put("" + inRowCounter, CommonExcelUtil.filterData(isAllColumnRequired, columnNames, rowMap));
                    ++inRowCounter;
                    continue;
                }
                recordsetMap.put("" + inRowCounter, CommonExcelUtil.filterData(isAllColumnRequired, columnNames, rowMap));
                ++inRowCounter;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        mainMap.put("ROWS", recordsetMap);
        return mainMap;
    }

    public Map<String, Map> runConditionQuery(Map<String, Object> queryMap, Map<String, String> colsNamesMap, Object oRecordset) throws FilloException {
        LinkedHashMap<String, Map> mainMap = new LinkedHashMap<String, Map>();
        LinkedHashMap<String, Map> recordsetMap = new LinkedHashMap<String, Map>();
        HashMap<String, String> tableMap = new HashMap<String, String>();
        int inRowCounter = 0;
        String strQuery = queryMap.get("QUERY").toString();
        String strTableName = queryMap.get("TABLE").toString();
        String strColumns = queryMap.get("TABLE").toString();
        String strWhereFlag = queryMap.get("WHERE_FLAG").toString();
        Map oldRows = (Map)oRecordset;
        for (Map.Entry entry : oldRows.entrySet()) {
            Map rowMap = (Map)entry.getValue();
            if (strWhereFlag.equalsIgnoreCase("TRUE")) {
                if (!CommonExcelUtil.whereCondition(rowMap, queryMap)) continue;
                recordsetMap.put("" + inRowCounter, rowMap);
                ++inRowCounter;
                continue;
            }
            recordsetMap.put("" + inRowCounter, rowMap);
            ++inRowCounter;
        }
        tableMap.put("NAME", strTableName);
        mainMap.put("TABLE", tableMap);
        mainMap.put("COLS", colsNamesMap);
        mainMap.put("ROWS", recordsetMap);
        return mainMap;
    }

    private int getCellType(Cell cell, FormulaEvaluator evaluator) {
        int inType = 1;
        try {
            inType = evaluator.evaluateInCell(cell).getCellType().ordinal();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inType;
    }
}

