/*
 * Decompiled with CFR 0.152.
 */
package com.codoid.products.fillo;

import com.codoid.products.exception.FilloException;
import com.codoid.products.fillo.SelectExcelUtil;
import com.codoid.products.parser.SelectQueryParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Select {
    private Object oConnection;
    private String strQuery;
    private SelectQueryParser selectQueryParser;
    private Map<String, String> colsNamesMap;
    private Object oRecordset;

    public Select(Object oConnection, String strQuery) {
        this.oConnection = oConnection;
        this.strQuery = strQuery;
        this.selectQueryParser = new SelectQueryParser(this.strQuery);
    }

    public Select(String strTableName, String strQuery, Map<String, String> colsNamesMap, Object oRecordset) {
        this.strQuery = strQuery;
        this.colsNamesMap = colsNamesMap;
        this.oRecordset = oRecordset;
        this.selectQueryParser = new SelectQueryParser(this.strQuery);
    }

    public Object getRecordset() throws FilloException {
        Map<String, Map> oRecordset = null;
        Map<String, Map<String, String>> whereConditionsMap = null;
        if (this.selectQueryParser.initializeQuery()) {
            HashMap queryMap = new HashMap();
            String strTableName = this.selectQueryParser.getTableName();
            boolean blWhereConditionApplicable = this.selectQueryParser.isWherePresent();
            boolean isAllColumnRequired = this.selectQueryParser.isAllColumnRequired();
            ArrayList<String> columnNames = null;
            if (!isAllColumnRequired) {
                columnNames = this.selectQueryParser.getColumnsNames();
            }
            if (blWhereConditionApplicable) {
                whereConditionsMap = this.selectQueryParser.getAllWhereDetails();
            }
            SelectExcelUtil selectExcelUtil = new SelectExcelUtil();
            oRecordset = selectExcelUtil.runSelectQuery(this.oConnection, this.strQuery, strTableName, columnNames, isAllColumnRequired, blWhereConditionApplicable, whereConditionsMap);
        }
        return oRecordset;
    }

    public Object getRecordsetForCondition() throws FilloException {
        try {
            if (this.selectQueryParser.initializeQuery()) {
                HashMap<String, Object> queryMap = new HashMap<String, Object>();
                String strColumnNames = "*";
                String strTableName = this.selectQueryParser.getTableName();
                boolean blWhereConditionApplicable = this.selectQueryParser.isWherePresent();
                queryMap.put("QUERY", this.strQuery);
                queryMap.put("WHERE_FLAG", "" + blWhereConditionApplicable);
                if (blWhereConditionApplicable) {
                    queryMap.put("WHERE_COLUMN", this.selectQueryParser.getWhereColumn());
                    queryMap.put("WHERE_VALUE", this.selectQueryParser.getWhereValue());
                    queryMap.put("WHERE_OPERATOR", this.selectQueryParser.getWhereOperator());
                    queryMap.put("WHERE_VALUE_TYPE", this.selectQueryParser.getWhereValueType());
                }
                queryMap.put("COLUMNS", strColumnNames);
                queryMap.put("TABLE", strTableName);
                SelectExcelUtil selectExcelUtil = new SelectExcelUtil();
                this.oRecordset = selectExcelUtil.runConditionQuery(queryMap, this.colsNamesMap, this.oRecordset);
            }
        }
        catch (Exception e) {
            throw new FilloException("Invalid WHERE condtion");
        }
        return this.oRecordset;
    }
}

