/*
 * Decompiled with CFR 0.152.
 */
package com.codoid.products.fillo;

import com.codoid.products.exception.FilloException;
import com.codoid.products.fillo.CommonExcelUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class InsertExcelUtil {
    FormulaEvaluator evaluator = null;
    private int noOfColumnsAffected = 0;
    int rowStart;
    int rowEnd;
    Row firstRow = null;

    public int runInsertQuery(String strFilePath, FileInputStream file, Object oConnection, Map<String, Object> queryMap) throws FilloException {
        boolean inRowCounter = false;
        String strQuery = queryMap.get("QUERY").toString();
        String strTableName = queryMap.get("TABLE").toString();
        Map insertColumnNamesAndValuesMap = (Map)queryMap.get("COLUMN_DETAILS");
        Workbook workbook = (Workbook)oConnection;
        this.evaluator = workbook.getCreationHelper().createFormulaEvaluator();
        Sheet sheet = workbook.getSheet(strTableName);
        if (sheet == null) {
            throw new FilloException(strTableName + " table is not found");
        }
        if (System.getProperty("ROW") == null) {
            this.rowStart = sheet.getFirstRowNum() + 1;
            this.firstRow = sheet.getRow(sheet.getFirstRowNum());
        } else {
            this.rowStart = Integer.parseInt(System.getProperty("ROW"));
            this.firstRow = sheet.getRow(this.rowStart - 1);
        }
        this.rowEnd = sheet.getLastRowNum();
        int colStart = System.getProperty("COLUMN") == null ? 0 : Integer.parseInt(System.getProperty("COLUMN")) - 1;
        Map<String, String> columnNamesMap = CommonExcelUtil.getColumnNames(colStart, this.firstRow);
        if (columnNamesMap.size() == 0) {
            throw new FilloException("Table header are missing. Table Name:" + strTableName);
        }
        try {
            Row newRow = sheet.createRow(this.rowEnd + 1);
            LinkedHashMap<String, Cell> rowCellMap = new LinkedHashMap<String, Cell>();
            int inColumnCount = columnNamesMap.size() + colStart - 1;
            for (int inCol = colStart; inCol <= inColumnCount; ++inCol) {
                String strColumnName = columnNamesMap.get("" + inCol).toString().toUpperCase();
                Cell cell = newRow.createCell(inCol);
                rowCellMap.put(strColumnName, cell);
            }
            this.noOfColumnsAffected = this.insertValues(insertColumnNamesAndValuesMap, rowCellMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            workbook.getCreationHelper().createFormulaEvaluator().evaluateAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveWorkBook(strFilePath, workbook);
        return this.noOfColumnsAffected;
    }

    public int insertValues(Map<String, String> insertColumnNamesAndValuesMap, Map<String, Cell> rowCellMap) {
        int insertColumnCount = 0;
        try {
            for (Map.Entry<String, String> entry : insertColumnNamesAndValuesMap.entrySet()) {
                String strColumnName = entry.getKey().toString();
                String strValue = entry.getValue().toString();
                if (!rowCellMap.containsKey(strColumnName)) continue;
                CommonExcelUtil.setCellValue(rowCellMap.get(strColumnName), strValue);
                ++insertColumnCount;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return insertColumnCount;
    }

    public void saveWorkBook(String strFilePath, Workbook workbook) throws FilloException {
        try {
            FileOutputStream out = new FileOutputStream(strFilePath);
            workbook.write(out);
            out.close();
        }
        catch (Exception e) {
            this.noOfColumnsAffected = 0;
            throw new FilloException("Insert query cannot be proccesed, if File is already opened. File Path-" + strFilePath);
        }
    }
}

