/*
 * Decompiled with CFR 0.152.
 */
package com.codoid.products.fillo;

import com.codoid.products.exception.FilloException;
import com.codoid.products.fillo.DatabaseMetaData;
import com.codoid.products.fillo.Delete;
import com.codoid.products.fillo.Insert;
import com.codoid.products.fillo.Recordset;
import com.codoid.products.fillo.Select;
import com.codoid.products.fillo.Update;
import com.codoid.products.parser.CommonQueryParser;
import com.codoid.products.utils.FilenameUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Connection {
    private Object oConnection;
    private Object oRecordset;
    private boolean blConnectionStatus = false;
    private FileInputStream file;
    private String strFilePath;

    public Connection(Object oConnection, FileInputStream file, String strFilePath, boolean blStatus) {
        this.oConnection = oConnection;
        this.blConnectionStatus = blStatus;
        this.file = file;
        this.strFilePath = strFilePath;
    }

    public void close() {
        this.blConnectionStatus = false;
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DatabaseMetaData getMetaData() {
        DatabaseMetaData databaseMetaData = new DatabaseMetaData(this.oConnection);
        return databaseMetaData;
    }

    public Recordset executeQuery(String strQuery) throws FilloException {
        strQuery = strQuery.toUpperCase().trim();
        if (!this.blConnectionStatus) {
            throw new FilloException("Connection closed");
        }
        Select select = new Select(this.oConnection, strQuery);
        this.oRecordset = select.getRecordset();
        return new Recordset(this.oRecordset);
    }

    public int executeUpdate(String strQuery) throws FilloException {
        int noOfRowsAffected = 0;
        strQuery = strQuery.trim();
        if (this.blConnectionStatus) {
            String strQueryType = CommonQueryParser.getQueryType(strQuery);
            if (strQueryType.equalsIgnoreCase("UPDATE")) {
                Update update = new Update(this.strFilePath, this.file, this.oConnection, strQuery);
                noOfRowsAffected = update.executeUpdate();
                System.out.println(noOfRowsAffected + " row(s) affected");
                this.reConnect();
            } else if (strQueryType.equalsIgnoreCase("DELETE")) {
                Delete delete = new Delete(this.strFilePath, this.file, this.oConnection, strQuery);
                noOfRowsAffected = delete.executeDelete();
                System.out.println(noOfRowsAffected + " row(s) affected");
                this.reConnect();
            } else if (strQueryType.equalsIgnoreCase("INSERT")) {
                int noOfCoulumnsAffected = 0;
                Insert insert = new Insert(this.strFilePath, this.file, this.oConnection, strQuery);
                noOfCoulumnsAffected = insert.executeInsert();
                System.out.println(noOfCoulumnsAffected + " columns(s) affected");
                this.reConnect();
            }
        } else {
            throw new FilloException("Connection closed");
        }
        return noOfRowsAffected;
    }

    public void reConnect() throws FilloException {
        Workbook workbook = null;
        try {
            this.file = new FileInputStream(new File(this.strFilePath));
            workbook = this.getWorkbook(this.file, this.strFilePath);
        }
        catch (IOException e) {
            throw new FilloException("Workbook is not found - " + this.strFilePath);
        }
        this.oConnection = workbook;
    }

    private Workbook getWorkbook(FileInputStream file, String strFilePath) throws FilloException, IOException {
        Workbook wb;
        block6: {
            wb = null;
            try {
                if (FilenameUtils.getExtension(strFilePath).equalsIgnoreCase("XLS")) {
                    wb = new HSSFWorkbook(file);
                    break block6;
                }
                if (FilenameUtils.getExtension(strFilePath).equalsIgnoreCase("XLSX")) {
                    wb = new XSSFWorkbook(file);
                    break block6;
                }
                if (FilenameUtils.getExtension(strFilePath).equalsIgnoreCase("XLSM")) {
                    wb = new XSSFWorkbook(OPCPackage.open(file));
                    break block6;
                }
                throw new FilloException("Invalid file format - " + strFilePath);
            }
            catch (IOException e) {
                throw new FilloException("Unable to connect workbook - " + strFilePath);
            }
            catch (InvalidFormatException e) {
                throw new FilloException("Unable to connect workbook - " + strFilePath);
            }
        }
        return wb;
    }

    public boolean createTable(String strSheetName) throws FilloException {
        boolean blCreatedTable = false;
        try {
            Workbook wb = (Workbook)this.oConnection;
            if (wb.getSheetIndex(strSheetName) >= 0) {
                throw new FilloException("Unable to create table in " + this.strFilePath + " workbook-" + strSheetName + " sheet already exists");
            }
            Sheet sheet = wb.createSheet(strSheetName);
            FileOutputStream out = new FileOutputStream(this.strFilePath);
            wb.write(out);
            out.close();
            blCreatedTable = true;
        }
        catch (IOException e) {
            throw new FilloException("Unable to create table in " + this.strFilePath + " workbook");
        }
        return blCreatedTable;
    }

    public boolean createTable(String strSheetName, String[] arrColumnNames) throws FilloException {
        boolean blCreatedTable = false;
        try {
            Workbook wb = (Workbook)this.oConnection;
            if (wb.getSheetIndex(strSheetName) < 0) {
                Sheet sheet = wb.createSheet(strSheetName);
                Row firstRow = sheet.createRow(0);
                int inColumnCount = arrColumnNames.length - 1;
                for (int inCol = 0; inCol <= inColumnCount; ++inCol) {
                    String strColumnName = arrColumnNames[inCol];
                    Cell cell = firstRow.createCell(inCol);
                    cell.setCellValue(strColumnName);
                }
            } else {
                throw new FilloException("Unable to create table in " + this.strFilePath + " workbook-" + strSheetName + " sheet already exists");
            }
            FileOutputStream out = new FileOutputStream(this.strFilePath);
            wb.write(out);
            out.close();
            blCreatedTable = true;
        }
        catch (IOException e) {
            throw new FilloException("Unable to create table in " + this.strFilePath + " workbook");
        }
        return blCreatedTable;
    }

    public boolean deleteTable(String strSheetName) throws FilloException {
        boolean blDeletedTable = false;
        try {
            Workbook wb = (Workbook)this.oConnection;
            Sheet sheet = wb.getSheet(strSheetName);
            int inSheetIndex = wb.getSheetIndex(sheet);
            wb.removeSheetAt(inSheetIndex);
            FileOutputStream out = new FileOutputStream(this.strFilePath);
            wb.write(out);
            out.close();
            blDeletedTable = true;
        }
        catch (Exception e) {
            throw new FilloException("Unable to delete table in " + this.strFilePath + " workbook");
        }
        return blDeletedTable;
    }
}

