/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.types;

import com.akiban.sql.StandardException;
import com.akiban.sql.types.CharacterTypeAttributes;
import com.akiban.sql.types.TypeId;

public final class DataTypeDescriptor {
    public static final int MAXIMUM_WIDTH_UNKNOWN = -1;
    public static final DataTypeDescriptor MEDIUMINT = new DataTypeDescriptor(TypeId.MEDIUMINT_ID, true);
    public static final DataTypeDescriptor MEDIUMINT_NOT_NULL = MEDIUMINT.getNullabilityType(true);
    public static final DataTypeDescriptor INTEGER = new DataTypeDescriptor(TypeId.INTEGER_ID, true);
    public static final DataTypeDescriptor INTEGER_NOT_NULL = INTEGER.getNullabilityType(false);
    public static final DataTypeDescriptor SMALLINT = new DataTypeDescriptor(TypeId.SMALLINT_ID, true);
    public static final DataTypeDescriptor SMALLINT_NOT_NULL = SMALLINT.getNullabilityType(false);
    private TypeId typeId;
    private int precision;
    private int scale;
    private boolean isNullable;
    private int maximumWidth;
    private CharacterTypeAttributes characterAttributes;

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(int jdbcType) {
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcType, true);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(int jdbcType, int length) {
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcType, true, length);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(int jdbcType, boolean isNullable) {
        switch (jdbcType) {
            case 4: {
                return isNullable ? INTEGER : INTEGER_NOT_NULL;
            }
            case 5: {
                return isNullable ? SMALLINT : SMALLINT_NOT_NULL;
            }
        }
        TypeId typeId = TypeId.getBuiltInTypeId(jdbcType);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, isNullable);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(int jdbcType, boolean isNullable, int maxLength) {
        TypeId typeId = TypeId.getBuiltInTypeId(jdbcType);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, isNullable, maxLength);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(String sqlTypeName) {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(sqlTypeName), true);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(String sqlTypeName, int length) {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(sqlTypeName), true, length);
    }

    public static DataTypeDescriptor getSQLDataTypeDescriptor(String javaTypeName) throws StandardException {
        return DataTypeDescriptor.getSQLDataTypeDescriptor(javaTypeName, true);
    }

    public static DataTypeDescriptor getSQLDataTypeDescriptor(String javaTypeName, boolean isNullable) throws StandardException {
        TypeId typeId = TypeId.getSQLTypeForJavaType(javaTypeName);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, isNullable);
    }

    public static DataTypeDescriptor getSQLDataTypeDescriptor(String javaTypeName, int precision, int scale, boolean isNullable, int maximumWidth) throws StandardException {
        TypeId typeId = TypeId.getSQLTypeForJavaType(javaTypeName);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, precision, scale, isNullable, maximumWidth);
    }

    public static DataTypeDescriptor getRowMultiSet(String[] columnNames, DataTypeDescriptor[] columnTypes) {
        return new DataTypeDescriptor(TypeId.getRowMultiSet(columnNames, columnTypes), true);
    }

    public DataTypeDescriptor(TypeId typeId, int precision, int scale, boolean isNullable, int maximumWidth) {
        this.typeId = typeId;
        this.precision = precision;
        this.scale = scale;
        this.isNullable = isNullable;
        this.maximumWidth = maximumWidth;
    }

    public DataTypeDescriptor(TypeId typeId, boolean isNullable, int maximumWidth) {
        this.typeId = typeId;
        this.isNullable = isNullable;
        this.maximumWidth = maximumWidth;
    }

    public DataTypeDescriptor(TypeId typeId, boolean isNullable) {
        this.typeId = typeId;
        this.precision = typeId.getMaximumPrecision();
        this.scale = typeId.getMaximumScale();
        this.isNullable = isNullable;
        this.maximumWidth = typeId.getMaximumMaximumWidth();
    }

    private DataTypeDescriptor(DataTypeDescriptor source, boolean isNullable) {
        this.typeId = source.typeId;
        this.precision = source.precision;
        this.scale = source.scale;
        this.isNullable = isNullable;
        this.maximumWidth = source.maximumWidth;
        this.characterAttributes = source.characterAttributes;
    }

    private DataTypeDescriptor(DataTypeDescriptor source, int precision, int scale, boolean isNullable, int maximumWidth) {
        this.typeId = source.typeId;
        this.precision = precision;
        this.scale = scale;
        this.isNullable = isNullable;
        this.maximumWidth = maximumWidth;
    }

    public DataTypeDescriptor(TypeId typeId, boolean isNullable, int maximumWidth, CharacterTypeAttributes characterAttributes) {
        this.typeId = typeId;
        this.isNullable = isNullable;
        this.maximumWidth = maximumWidth;
        this.characterAttributes = characterAttributes;
    }

    public DataTypeDescriptor(DataTypeDescriptor source, CharacterTypeAttributes characterAttributes) {
        this.typeId = source.typeId;
        this.precision = source.precision;
        this.scale = source.scale;
        this.isNullable = source.isNullable;
        this.maximumWidth = source.maximumWidth;
        this.characterAttributes = characterAttributes;
    }

    public DataTypeDescriptor getDominantType(DataTypeDescriptor otherDTS) throws StandardException {
        DataTypeDescriptor higherType;
        int maximumWidth;
        DataTypeDescriptor lowerType = null;
        int precision = this.getPrecision();
        int scale = this.getScale();
        TypeId thisType = this.getTypeId();
        TypeId otherType = otherDTS.getTypeId();
        boolean nullable = this.isNullable() || otherDTS.isNullable();
        int n = maximumWidth = this.getMaximumWidth() > otherDTS.getMaximumWidth() ? this.getMaximumWidth() : otherDTS.getMaximumWidth();
        if (!thisType.userType() && !otherType.userType()) {
            TypeId lowerTypeId;
            TypeId higherTypeId;
            if (thisType.typePrecedence() > otherType.typePrecedence()) {
                higherType = this;
                lowerType = otherDTS;
                higherTypeId = thisType;
                lowerTypeId = otherType;
            } else {
                higherType = otherDTS;
                lowerType = this;
                higherTypeId = otherType;
                lowerTypeId = thisType;
            }
            if (higherTypeId.isRealTypeId() && !lowerTypeId.isRealTypeId() && lowerTypeId.isNumericTypeId()) {
                higherType = DataTypeDescriptor.getBuiltInDataTypeDescriptor(8);
                higherTypeId = TypeId.getBuiltInTypeId(8);
            }
            if (higherTypeId.isDecimalTypeId() && !lowerTypeId.isStringTypeId()) {
                precision = higherTypeId.getPrecision(this, otherDTS);
                if (precision > 31) {
                    precision = 31;
                }
                maximumWidth = (scale = higherTypeId.getScale(this, otherDTS)) > 0 ? precision + 3 : precision + 1;
            } else if (thisType.typePrecedence() != otherType.typePrecedence()) {
                int charMaxWidth;
                precision = higherType.getPrecision();
                scale = higherType.getScale();
                if (lowerTypeId.isStringTypeId() && higherTypeId.isBitTypeId() && !higherTypeId.isLongConcatableTypeId()) {
                    if (lowerTypeId.isLongConcatableTypeId()) {
                        maximumWidth = maximumWidth > 0x7FFFFFF ? Integer.MAX_VALUE : (maximumWidth *= 16);
                    } else {
                        int fromWidth = lowerType.getMaximumWidth();
                        charMaxWidth = fromWidth > 0x7FFFFFF ? Integer.MAX_VALUE : 16 * fromWidth;
                        int n2 = maximumWidth = maximumWidth >= charMaxWidth ? maximumWidth : charMaxWidth;
                    }
                }
                if (lowerTypeId.isStringTypeId() && !lowerTypeId.isLongConcatableTypeId() && higherTypeId.isDecimalTypeId()) {
                    charMaxWidth = lowerType.getMaximumWidth();
                    int charPrecision = charMaxWidth > 0x3FFFFFFE ? 0x7FFFFFFC : charMaxWidth * 2;
                    if (precision < charPrecision) {
                        precision = charPrecision;
                    }
                    if (scale < charMaxWidth) {
                        scale = charMaxWidth;
                    }
                    maximumWidth = precision + 3;
                }
            }
        } else {
            if (!thisType.equals(otherType)) {
                throw new StandardException("Two different user-defined types");
            }
            higherType = this;
            precision = higherType.getPrecision();
            scale = higherType.getScale();
        }
        higherType = new DataTypeDescriptor(higherType, precision, scale, nullable, maximumWidth);
        higherType.characterAttributes = CharacterTypeAttributes.mergeCollations(this.characterAttributes, otherDTS.characterAttributes);
        return higherType;
    }

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    public TypeId getTypeId() {
        return this.typeId;
    }

    public String getTypeName() {
        return this.typeId.getSQLTypeName();
    }

    public int getJDBCTypeId() {
        return this.typeId.getJDBCTypeId();
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isRowMultiSet() {
        return this.typeId.isRowMultiSet();
    }

    public DataTypeDescriptor getNullabilityType(boolean isNullable) {
        if (this.isNullable() == isNullable) {
            return this;
        }
        return new DataTypeDescriptor(this, isNullable);
    }

    public CharacterTypeAttributes getCharacterAttributes() {
        return this.characterAttributes;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DataTypeDescriptor)) {
            return false;
        }
        DataTypeDescriptor odtd = (DataTypeDescriptor)other;
        return this.getTypeName().equals(odtd.getTypeName()) && this.precision == odtd.getPrecision() && this.scale == odtd.getScale() && this.isNullable == odtd.isNullable() && this.maximumWidth == odtd.getMaximumWidth() && !(this.characterAttributes == null ? odtd.characterAttributes != null : !this.characterAttributes.equals(odtd.characterAttributes));
    }

    public boolean comparable(DataTypeDescriptor compareWithDTD, boolean forEquals) {
        TypeId compareWithTypeID = compareWithDTD.getTypeId();
        int compareWithJDBCTypeId = compareWithTypeID.getJDBCTypeId();
        if (!this.typeId.isComparable() || !compareWithTypeID.isComparable()) {
            return false;
        }
        if (this.typeId.equals(compareWithTypeID)) {
            return true;
        }
        if (!this.typeId.isUserDefinedTypeId() && compareWithTypeID.isUserDefinedTypeId()) {
            return compareWithDTD.comparable(this, forEquals);
        }
        if (this.typeId.isNumericTypeId()) {
            return compareWithTypeID.isNumericTypeId();
        }
        if (this.typeId.isStringTypeId()) {
            if (compareWithTypeID.isDateTimeTimeStampTypeID() || compareWithTypeID.isBooleanTypeId()) {
                return true;
            }
            return compareWithTypeID.isStringTypeId() && this.typeId.isStringTypeId();
        }
        if (this.typeId.isBitTypeId()) {
            return compareWithTypeID.isBitTypeId();
        }
        if (this.typeId.isBooleanTypeId()) {
            return compareWithTypeID.getSQLTypeName().equals(this.typeId.getSQLTypeName()) || compareWithTypeID.isStringTypeId();
        }
        if (this.typeId.getJDBCTypeId() == 91) {
            return compareWithJDBCTypeId == 91 || compareWithJDBCTypeId == 93 || compareWithTypeID.isStringTypeId();
        }
        if (this.typeId.getJDBCTypeId() == 92) {
            return compareWithJDBCTypeId == 92 || compareWithTypeID.isStringTypeId();
        }
        if (this.typeId.getJDBCTypeId() == 93) {
            return compareWithJDBCTypeId == 93 || compareWithJDBCTypeId == 91 || compareWithTypeID.isStringTypeId();
        }
        return false;
    }

    public String getSQLstring() {
        return this.typeId.toParsableString(this);
    }

    public static boolean isJDBCTypeEquivalent(int existingType, int jdbcTypeId) {
        if (existingType == jdbcTypeId) {
            return true;
        }
        if (DataTypeDescriptor.isNumericType(existingType)) {
            if (DataTypeDescriptor.isNumericType(jdbcTypeId)) {
                return true;
            }
            return DataTypeDescriptor.isCharacterType(jdbcTypeId);
        }
        if (DataTypeDescriptor.isCharacterType(existingType)) {
            if (DataTypeDescriptor.isCharacterType(jdbcTypeId)) {
                return true;
            }
            if (DataTypeDescriptor.isNumericType(jdbcTypeId)) {
                return true;
            }
            switch (jdbcTypeId) {
                case 91: 
                case 92: 
                case 93: {
                    return true;
                }
            }
            return false;
        }
        if (DataTypeDescriptor.isBinaryType(existingType)) {
            return DataTypeDescriptor.isBinaryType(jdbcTypeId);
        }
        if (existingType == 91 || existingType == 92) {
            if (DataTypeDescriptor.isCharacterType(jdbcTypeId)) {
                return true;
            }
            return jdbcTypeId == 93;
        }
        if (existingType == 93) {
            if (DataTypeDescriptor.isCharacterType(jdbcTypeId)) {
                return true;
            }
            return jdbcTypeId == 91;
        }
        return existingType == 2005 && DataTypeDescriptor.isCharacterType(jdbcTypeId);
    }

    public static boolean isNumericType(int jdbcType) {
        switch (jdbcType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private static boolean isCharacterType(int jdbcType) {
        switch (jdbcType) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private static boolean isBinaryType(int jdbcType) {
        switch (jdbcType) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAsciiStreamAssignable(int jdbcType) {
        return jdbcType == 2005 || DataTypeDescriptor.isCharacterType(jdbcType);
    }

    public static boolean isBinaryStreamAssignable(int jdbcType) {
        return jdbcType == 2004 || DataTypeDescriptor.isBinaryType(jdbcType);
    }

    public static boolean isCharacterStreamAssignable(int jdbcType) {
        return DataTypeDescriptor.isAsciiStreamAssignable(jdbcType);
    }

    public String toString() {
        String s = this.getSQLstring();
        if (this.characterAttributes != null) {
            s = s + " " + this.characterAttributes;
        }
        if (!this.isNullable()) {
            s = s + " NOT NULL";
        }
        return s;
    }

    public String getFullSQLTypeName() {
        StringBuffer sbuf = new StringBuffer(this.typeId.getSQLTypeName());
        if (this.typeId.isDecimalTypeId() || this.typeId.isNumericTypeId()) {
            sbuf.append("(");
            sbuf.append(this.getPrecision());
            sbuf.append(", ");
            sbuf.append(this.getScale());
            sbuf.append(")");
        } else if (this.typeId.isIntervalTypeId()) {
            if (this.typeId == TypeId.INTERVAL_SECOND_ID) {
                if (this.getPrecision() > 0) {
                    sbuf.append("(");
                    sbuf.append(this.getPrecision());
                    if (this.getScale() > 0) {
                        sbuf.append(", ");
                        sbuf.append(this.getScale());
                    }
                    sbuf.append(")");
                }
            } else {
                if (this.getPrecision() > 0) {
                    int idx = sbuf.indexOf(" ", 9);
                    if (idx < 0) {
                        idx = sbuf.length();
                    }
                    sbuf.insert(idx, ")");
                    sbuf.insert(idx, this.getPrecision());
                    sbuf.insert(idx, "(");
                }
                if (this.getScale() > 0) {
                    sbuf.append("(");
                    sbuf.append(this.getScale());
                    sbuf.append(")");
                }
            }
        } else if (this.typeId.variableLength()) {
            sbuf.append("(");
            sbuf.append(this.getMaximumWidth());
            sbuf.append(")");
        }
        return sbuf.toString();
    }

    public static int computeMaxWidth(int precision, int scale) {
        return scale == 0 ? precision + 1 : (scale == precision ? precision + 3 : precision + 2);
    }

    public DataTypeDescriptor getUnsigned() throws StandardException {
        TypeId unsignedTypeId;
        if (this.typeId == TypeId.SMALLINT_ID) {
            unsignedTypeId = TypeId.SMALLINT_UNSIGNED_ID;
        } else if (this.typeId == TypeId.MEDIUMINT_ID) {
            unsignedTypeId = TypeId.MEDIUMINT_UNSIGNED_ID;
        } else if (this.typeId == TypeId.INTEGER_ID) {
            unsignedTypeId = TypeId.INTEGER_UNSIGNED_ID;
        } else if (this.typeId == TypeId.TINYINT_ID) {
            unsignedTypeId = TypeId.TINYINT_UNSIGNED_ID;
        } else if (this.typeId == TypeId.BIGINT_ID) {
            unsignedTypeId = TypeId.BIGINT_UNSIGNED_ID;
        } else if (this.typeId == TypeId.REAL_ID) {
            unsignedTypeId = TypeId.REAL_UNSIGNED_ID;
        } else if (this.typeId == TypeId.DOUBLE_ID) {
            unsignedTypeId = TypeId.DOUBLE_UNSIGNED_ID;
        } else if (this.typeId == TypeId.DECIMAL_ID) {
            unsignedTypeId = TypeId.DECIMAL_UNSIGNED_ID;
        } else if (this.typeId == TypeId.NUMERIC_ID) {
            unsignedTypeId = TypeId.NUMERIC_UNSIGNED_ID;
        } else {
            throw new StandardException("Not a numeric type: " + this);
        }
        return new DataTypeDescriptor(unsignedTypeId, this.precision, this.scale, this.isNullable, this.maximumWidth);
    }

    public static int intervalMaxWidth(TypeId typeId, int precision, int scale) {
        int maxMax;
        if (typeId.getTypeFormatId() == 24) {
            if (precision == 0) {
                precision = 8;
            }
            maxMax = 11;
        } else {
            if (precision == 0) {
                precision = 8;
            }
            maxMax = 24;
        }
        if (typeId == TypeId.INTERVAL_YEAR_ID || typeId == TypeId.INTERVAL_MONTH_ID || typeId == TypeId.INTERVAL_DAY_ID || typeId == TypeId.INTERVAL_HOUR_ID || typeId == TypeId.INTERVAL_MINUTE_ID) {
            return precision;
        }
        if (typeId == TypeId.INTERVAL_SECOND_ID) {
            if (scale == 0) {
                return precision;
            }
            return precision + scale + 1;
        }
        if (typeId == TypeId.INTERVAL_DAY_HOUR_ID) {
            return precision + 3;
        }
        if (typeId == TypeId.INTERVAL_DAY_MINUTE_ID) {
            return precision + 6;
        }
        if (typeId == TypeId.INTERVAL_DAY_SECOND_ID) {
            if (scale == 0) {
                return precision + 9;
            }
            return precision + scale + 10;
        }
        if (typeId == TypeId.INTERVAL_HOUR_MINUTE_ID) {
            return precision + 3;
        }
        if (typeId == TypeId.INTERVAL_HOUR_SECOND_ID) {
            if (scale == 0) {
                return precision + 6;
            }
            return precision + scale + 7;
        }
        if (typeId == TypeId.INTERVAL_MINUTE_SECOND_ID) {
            if (scale == 0) {
                return precision + 3;
            }
            return precision + scale + 4;
        }
        return maxMax;
    }
}

