/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.ConstraintDefinitionNode;
import com.akiban.sql.parser.ModifyColumnNode;
import com.akiban.sql.parser.QueryTreeNode;

public class TableElementNode
extends QueryTreeNode {
    String name;
    ElementType elementType;

    @Override
    public void init(Object name) {
        this.name = (String)name;
    }

    @Override
    public void init(Object name, Object elementType) {
        this.name = (String)name;
        this.elementType = (ElementType)((Object)elementType);
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        TableElementNode other = (TableElementNode)node;
        this.name = other.name;
        this.elementType = other.elementType;
    }

    @Override
    public String toString() {
        return "name: " + this.name + "\n" + "elementType: " + (Object)((Object)this.getElementType()) + "\n" + super.toString();
    }

    boolean hasPrimaryKeyConstraint() {
        return false;
    }

    boolean hasUniqueKeyConstraint() {
        return false;
    }

    boolean hasForeignKeyConstraint() {
        return false;
    }

    boolean hasCheckConstraint() {
        return false;
    }

    boolean hasConstraint() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    ElementType getElementType() {
        if (this.hasForeignKeyConstraint()) {
            return ElementType.AT_ADD_FOREIGN_KEY_CONSTRAINT;
        }
        if (this.hasPrimaryKeyConstraint()) {
            return ElementType.AT_ADD_PRIMARY_KEY_CONSTRAINT;
        }
        if (this.hasUniqueKeyConstraint()) {
            return ElementType.AT_ADD_UNIQUE_CONSTRAINT;
        }
        if (this.hasCheckConstraint()) {
            return ElementType.AT_ADD_CHECK_CONSTRAINT;
        }
        if (this instanceof ConstraintDefinitionNode) {
            return ElementType.AT_DROP_CONSTRAINT;
        }
        if (this instanceof ModifyColumnNode) {
            if (this.getNodeType() == 113) {
                return ElementType.AT_DROP_COLUMN;
            }
            return ElementType.AT_MODIFY_COLUMN;
        }
        return this.elementType;
    }

    public static enum ElementType {
        AT_UNKNOWN,
        AT_ADD_FOREIGN_KEY_CONSTRAINT,
        AT_ADD_PRIMARY_KEY_CONSTRAINT,
        AT_ADD_UNIQUE_CONSTRAINT,
        AT_ADD_CHECK_CONSTRAINT,
        AT_DROP_CONSTRAINT,
        AT_MODIFY_COLUMN,
        AT_DROP_COLUMN,
        AT_DROP_INDEX,
        AT_ADD_INDEX,
        AT_RENAME,
        AT_RENAME_COLUMN;

    }
}

