/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.OrderByList;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ResultSetNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.Visitor;

public class SubqueryNode
extends ValueNode {
    private ResultSetNode resultSet;
    private SubqueryType subqueryType;
    private ValueNode leftOperand;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;

    @Override
    public void init(Object resultSet, Object subqueryType, Object leftOperand, Object orderCols, Object offset, Object fetchFirst) {
        this.resultSet = (ResultSetNode)resultSet;
        this.subqueryType = (SubqueryType)((Object)subqueryType);
        this.orderByList = (OrderByList)orderCols;
        this.offset = (ValueNode)offset;
        this.fetchFirst = (ValueNode)fetchFirst;
        this.leftOperand = (ValueNode)leftOperand;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        SubqueryNode other = (SubqueryNode)node;
        this.resultSet = (ResultSetNode)this.getNodeFactory().copyNode(other.resultSet, this.getParserContext());
        this.subqueryType = other.subqueryType;
        this.leftOperand = (ValueNode)this.getNodeFactory().copyNode(other.leftOperand, this.getParserContext());
        this.orderByList = (OrderByList)this.getNodeFactory().copyNode(other.orderByList, this.getParserContext());
        this.offset = (ValueNode)this.getNodeFactory().copyNode(other.offset, this.getParserContext());
        this.fetchFirst = (ValueNode)this.getNodeFactory().copyNode(other.fetchFirst, this.getParserContext());
    }

    @Override
    public String toString() {
        return "subqueryType: " + (Object)((Object)this.subqueryType) + "\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.resultSet != null) {
            this.printLabel(depth, "resultSet: ");
            this.resultSet.treePrint(depth + 1);
        }
        if (this.leftOperand != null) {
            this.printLabel(depth, "leftOperand: ");
            this.leftOperand.treePrint(depth + 1);
        }
        if (this.orderByList != null) {
            this.printLabel(depth, "orderByList: ");
            this.orderByList.treePrint(depth + 1);
        }
        if (this.offset != null) {
            this.printLabel(depth, "offset: ");
            this.offset.treePrint(depth + 1);
        }
        if (this.fetchFirst != null) {
            this.printLabel(depth, "fetchFirst: ");
            this.fetchFirst.treePrint(depth + 1);
        }
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.resultSet != null) {
            this.resultSet = (ResultSetNode)this.resultSet.accept(v);
        }
        if (this.leftOperand != null) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(v);
        }
        if (this.orderByList != null) {
            this.orderByList = (OrderByList)this.orderByList.accept(v);
        }
        if (this.offset != null) {
            this.offset = (ValueNode)this.offset.accept(v);
        }
        if (this.fetchFirst != null) {
            this.fetchFirst = (ValueNode)this.fetchFirst.accept(v);
        }
    }

    public ResultSetNode getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(ResultSetNode resultSet) {
        this.resultSet = resultSet;
    }

    public SubqueryType getSubqueryType() {
        return this.subqueryType;
    }

    public void setSubqueryType(SubqueryType subqueryType) {
        this.subqueryType = subqueryType;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) {
        return false;
    }

    public OrderByList getOrderByList() {
        return this.orderByList;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    public ValueNode getFetchFirst() {
        return this.fetchFirst;
    }

    public ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    public static enum SubqueryType {
        FROM,
        IN,
        NOT_IN,
        EQ_ANY,
        EQ_ALL,
        NE_ANY,
        NE_ALL,
        GT_ANY,
        GT_ALL,
        GE_ANY,
        GE_ALL,
        LT_ANY,
        LT_ALL,
        LE_ANY,
        LE_ALL,
        EXISTS,
        NOT_EXISTS,
        EXPRESSION;

    }
}

