/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.ValueNodeList;
import com.akiban.sql.parser.Visitor;

public class SimpleCaseNode
extends ValueNode {
    private ValueNode operand;
    private ValueNodeList caseOperands;
    private ValueNodeList resultValues;
    private ValueNode elseValue;

    @Override
    public void init(Object operand) throws StandardException {
        this.operand = (ValueNode)operand;
        this.caseOperands = (ValueNodeList)this.getNodeFactory().getNode(15, this.getParserContext());
        this.resultValues = (ValueNodeList)this.getNodeFactory().getNode(15, this.getParserContext());
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        SimpleCaseNode other = (SimpleCaseNode)node;
        this.operand = (ValueNode)this.getNodeFactory().copyNode(other.operand, this.getParserContext());
        this.caseOperands = (ValueNodeList)this.getNodeFactory().copyNode(other.caseOperands, this.getParserContext());
        this.resultValues = (ValueNodeList)this.getNodeFactory().copyNode(other.resultValues, this.getParserContext());
        this.elseValue = other.elseValue == null ? null : (ValueNode)this.getNodeFactory().copyNode(other.elseValue, this.getParserContext());
    }

    public ValueNode getOperand() {
        return this.operand;
    }

    public ValueNodeList getCaseOperands() {
        return this.caseOperands;
    }

    public ValueNodeList getResultValues() {
        return this.resultValues;
    }

    public ValueNode getElseValue() {
        return this.elseValue;
    }

    public void setElseValue(ValueNode elseValue) {
        this.elseValue = elseValue;
    }

    public int getNumberOfCases() {
        return this.caseOperands.size();
    }

    public ValueNode getCaseOperand(int index) {
        return (ValueNode)this.caseOperands.get(index);
    }

    public ValueNode getResultValue(int index) {
        return (ValueNode)this.resultValues.get(index);
    }

    public void addCase(ValueNode operand, ValueNode result) {
        this.caseOperands.add(operand);
        this.resultValues.add(result);
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "operand: ");
        this.operand.treePrint(depth + 1);
        for (int i = 0; i < this.getNumberOfCases(); ++i) {
            this.printLabel(depth, "when: ");
            this.getCaseOperand(i).treePrint(depth + 1);
            this.printLabel(depth, "then: ");
            this.getResultValue(i).treePrint(depth + 1);
        }
        if (this.elseValue != null) {
            this.printLabel(depth, "else: ");
            this.elseValue.treePrint(depth + 1);
        }
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        this.operand = (ValueNode)this.operand.accept(v);
        this.caseOperands = (ValueNodeList)this.caseOperands.accept(v);
        this.resultValues = (ValueNodeList)this.resultValues.accept(v);
        if (this.elseValue != null) {
            this.elseValue = (ValueNode)this.elseValue.accept(v);
        }
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeType(o)) {
            SimpleCaseNode other = (SimpleCaseNode)o;
            return this.operand.isEquivalent(other.operand) && this.caseOperands.isEquivalent(other.caseOperands) && this.resultValues.isEquivalent(other.resultValues) && (this.elseValue == null ? other.elseValue == null : this.elseValue.isEquivalent(other.elseValue));
        }
        return false;
    }
}

