/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.DDLStatementNode;
import com.akiban.sql.parser.ExistenceCheck;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.types.AliasInfo;

public class DropAliasNode
extends DDLStatementNode {
    private AliasInfo.Type aliasType;
    private ExistenceCheck existenceCheck;

    @Override
    public void init(Object dropAliasName, Object aliasType, Object existenceCheck) throws StandardException {
        TableName dropItem = (TableName)dropAliasName;
        this.initAndCheck(dropItem);
        this.aliasType = (AliasInfo.Type)((Object)aliasType);
        this.existenceCheck = (ExistenceCheck)((Object)existenceCheck);
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        DropAliasNode other = (DropAliasNode)node;
        this.aliasType = other.aliasType;
        this.existenceCheck = other.existenceCheck;
    }

    public AliasInfo.Type getAliasType() {
        return this.aliasType;
    }

    public ExistenceCheck getExistenceCheck() {
        return this.existenceCheck;
    }

    @Override
    public String toString() {
        return super.toString() + "existenceCheck: " + (Object)((Object)this.existenceCheck) + "\n";
    }

    @Override
    public String statementToString() {
        return "DROP " + DropAliasNode.aliasTypeName(this.aliasType);
    }

    private static String aliasTypeName(AliasInfo.Type type) {
        String typeName = null;
        switch (type) {
            case PROCEDURE: {
                typeName = "PROCEDURE";
                break;
            }
            case FUNCTION: {
                typeName = "FUNCTION";
                break;
            }
            case SYNONYM: {
                typeName = "SYNONYM";
                break;
            }
            case UDT: {
                typeName = "TYPE";
            }
        }
        return typeName;
    }
}

