/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.DDLStatementNode;
import com.akiban.sql.parser.ExistenceCheck;
import com.akiban.sql.parser.IndexColumnList;
import com.akiban.sql.parser.IndexDefinition;
import com.akiban.sql.parser.JoinNode;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.StorageLocation;
import com.akiban.sql.parser.TableName;
import java.util.Properties;

public class CreateIndexNode
extends DDLStatementNode
implements IndexDefinition {
    boolean unique;
    String indexType;
    TableName indexName;
    TableName tableName;
    IndexColumnList columnList;
    JoinNode.JoinType joinType;
    Properties properties;
    ExistenceCheck existenceCheck;
    StorageLocation storageLocation;

    @Override
    public void init(Object unique, Object indexType, Object indexName, Object tableName, Object columnList, Object joinType, Object properties, Object existenceCheck, Object storageLocation) throws StandardException {
        this.initAndCheck(indexName);
        this.unique = (Boolean)unique;
        this.indexType = (String)indexType;
        this.indexName = (TableName)indexName;
        this.tableName = (TableName)tableName;
        this.columnList = (IndexColumnList)columnList;
        this.joinType = (JoinNode.JoinType)((Object)joinType);
        this.properties = (Properties)properties;
        this.existenceCheck = (ExistenceCheck)((Object)existenceCheck);
        this.storageLocation = (StorageLocation)((Object)storageLocation);
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        CreateIndexNode other = (CreateIndexNode)node;
        this.unique = other.unique;
        this.indexType = other.indexType;
        this.indexName = (TableName)this.getNodeFactory().copyNode(other.indexName, this.getParserContext());
        this.tableName = (TableName)this.getNodeFactory().copyNode(other.tableName, this.getParserContext());
        this.columnList = (IndexColumnList)this.getNodeFactory().copyNode(other.columnList, this.getParserContext());
        this.joinType = other.joinType;
        this.properties = other.properties;
        this.existenceCheck = other.existenceCheck;
        this.storageLocation = other.storageLocation;
    }

    @Override
    public String toString() {
        return super.toString() + "unique: " + this.unique + "\n" + "indexType: " + this.indexType + "\n" + "indexName: " + this.indexName + "\n" + "tableName: " + this.tableName + "\n" + "joinType: " + (Object)((Object)this.joinType) + "\n" + "properties: " + this.properties + "\n" + "existenceCheck: " + (Object)((Object)this.existenceCheck) + "\n" + "storageLocation: " + (Object)((Object)this.storageLocation) + "\n";
    }

    @Override
    public void printSubNodes(int depth) {
        if (this.columnList != null) {
            this.columnList.treePrint(depth + 1);
        }
    }

    @Override
    public String statementToString() {
        return "CREATE INDEX";
    }

    @Override
    public boolean getUniqueness() {
        return this.unique;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public TableName getIndexName() {
        return this.indexName;
    }

    public IndexColumnList getColumnList() {
        return this.columnList;
    }

    @Override
    public IndexColumnList getIndexColumnList() {
        return this.columnList;
    }

    @Override
    public JoinNode.JoinType getJoinType() {
        return this.joinType;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public TableName getIndexTableName() {
        return this.tableName;
    }

    public ExistenceCheck getExistenceCheck() {
        return this.existenceCheck;
    }

    public StorageLocation getStorageLocation() {
        return this.storageLocation;
    }
}

