/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.CursorNode;
import com.akiban.sql.parser.FromList;
import com.akiban.sql.parser.FromTable;
import com.akiban.sql.parser.NodeFactory;
import com.akiban.sql.parser.OrderByList;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ResultColumn;
import com.akiban.sql.parser.ResultColumnList;
import com.akiban.sql.parser.ResultSetNode;
import com.akiban.sql.parser.SQLParserContext;
import com.akiban.sql.parser.SelectNode;
import com.akiban.sql.parser.StatementNode;
import com.akiban.sql.parser.SubqueryNode;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.Visitor;

public class CopyStatementNode
extends StatementNode {
    private Mode mode;
    private TableName tableName;
    private ResultColumnList columnList;
    private SubqueryNode subquery;
    private String filename;
    private Format format;
    private String delimiter;
    private String nullString;
    private String quote;
    private String escape;
    private String encoding;
    private boolean header;
    private long commitFrequency;

    @Override
    public void init(Object mode, Object subquery, Object filename) {
        this.mode = (Mode)((Object)mode);
        this.subquery = (SubqueryNode)subquery;
        this.filename = (String)filename;
    }

    @Override
    public void init(Object mode, Object tableName, Object columnList, Object filename) {
        this.mode = (Mode)((Object)mode);
        this.tableName = (TableName)tableName;
        this.columnList = (ResultColumnList)columnList;
        this.filename = (String)filename;
    }

    public Mode getMode() {
        return this.mode;
    }

    public SubqueryNode getSubquery() {
        return this.subquery;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public ResultColumnList getColumnList() {
        return this.columnList;
    }

    public String getFilename() {
        return this.filename;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public boolean isHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public String getQuote() {
        return this.quote;
    }

    public void setQuote(String quote) {
        this.quote = quote;
    }

    public String getEscape() {
        return this.escape;
    }

    public void setEscape(String escape) {
        this.escape = escape;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public long getCommitFrequency() {
        return this.commitFrequency;
    }

    public void setCommitFrequency(long commitFrequency) {
        this.commitFrequency = commitFrequency;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        CopyStatementNode other = (CopyStatementNode)node;
        this.tableName = (TableName)this.getNodeFactory().copyNode(other.tableName, this.getParserContext());
        this.subquery = (SubqueryNode)this.getNodeFactory().copyNode(other.subquery, this.getParserContext());
        this.columnList = (ResultColumnList)this.getNodeFactory().copyNode(other.columnList, this.getParserContext());
        this.filename = other.filename;
        this.format = other.format;
        this.delimiter = other.delimiter;
        this.nullString = other.nullString;
        this.quote = other.quote;
        this.escape = other.escape;
        this.encoding = other.encoding;
    }

    @Override
    public String toString() {
        return "mode: " + (Object)((Object)this.mode) + "\n" + "tableName: " + this.tableName + "\n" + "filename: " + this.filename + "\n" + "format: " + (Object)((Object)this.format) + "\n" + "delimiter: " + this.delimiter + "\n" + "nullString: " + this.nullString + "\n" + "quote: " + this.quote + "\n" + "escape: " + this.escape + "\n" + "encoding: " + this.encoding + "\n" + "commitFrequency: " + this.commitFrequency + "\n" + super.toString();
    }

    @Override
    public String statementToString() {
        return "COPY";
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.subquery != null) {
            this.printLabel(depth, "subquery: ");
            this.subquery.treePrint(depth + 1);
        }
        if (this.columnList != null) {
            this.printLabel(depth, "columnList: ");
            this.columnList.treePrint(depth + 1);
        }
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.subquery != null) {
            this.subquery = (SubqueryNode)this.subquery.accept(v);
        }
        if (this.columnList != null) {
            this.columnList = (ResultColumnList)this.columnList.accept(v);
        }
    }

    public CursorNode asQuery() throws StandardException {
        ResultSetNode resultSet;
        NodeFactory nodeFactory = this.getNodeFactory();
        SQLParserContext parserContext = this.getParserContext();
        OrderByList orderBy = null;
        ValueNode offset = null;
        ValueNode limit = null;
        if (this.subquery != null) {
            resultSet = this.subquery.getResultSet();
            orderBy = this.subquery.getOrderByList();
            offset = this.subquery.getOffset();
            limit = this.subquery.getFetchFirst();
        } else {
            FromList fromList = (FromList)nodeFactory.getNode(37, parserContext);
            FromTable fromTable = (FromTable)nodeFactory.getNode(135, this.tableName, null, null, parserContext);
            fromList.addFromTable(fromTable);
            ResultColumnList selectList = this.columnList;
            if (selectList == null) {
                selectList = (ResultColumnList)nodeFactory.getNode(9, parserContext);
                ResultColumn star = (ResultColumn)nodeFactory.getNode(16, Boolean.FALSE, parserContext);
                selectList.addResultColumn(star);
            }
            resultSet = (SelectNode)nodeFactory.getNode(129, selectList, null, fromList, null, null, null, null, parserContext);
        }
        return (CursorNode)nodeFactory.getNode(147, "SELECT", resultSet, null, orderBy, offset, limit, null, null, parserContext);
    }

    public static enum Format {
        CSV,
        MYSQL_DUMP;

    }

    public static enum Mode {
        TO_TABLE,
        FROM_TABLE,
        FROM_SUBQUERY;

    }
}

