/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.types.TypeId;

public abstract class ConstantNode
extends ValueNode {
    Object value;

    @Override
    public void init(Object typeId, Object nullable, Object maximumWidth) throws StandardException {
        this.setType((TypeId)typeId, (Boolean)nullable, (Integer)maximumWidth);
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        ConstantNode other = (ConstantNode)node;
        this.value = other.value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "value: " + this.value + "\n" + super.toString();
    }

    @Override
    public boolean isConstantExpression() {
        return true;
    }

    boolean isNull() {
        return this.value == null;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeType(o)) {
            ConstantNode other = (ConstantNode)o;
            return other.getValue() == null && this.getValue() == null || other.getValue() != null && other.getValue().equals(this.getValue());
        }
        return false;
    }
}

