/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.DefaultNode;
import com.akiban.sql.parser.GenerationClauseNode;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.TableElementNode;
import com.akiban.sql.parser.UntypedNullConstantNode;
import com.akiban.sql.types.DataTypeDescriptor;

public class ColumnDefinitionNode
extends TableElementNode {
    boolean isAutoincrement;
    DataTypeDescriptor type;
    DefaultNode defaultNode;
    boolean keepCurrentDefault;
    GenerationClauseNode generationClauseNode;
    long autoincrementIncrement;
    long autoincrementStart;
    long autoinc_create_or_modify_Start_Increment;
    boolean autoincrementVerify;
    public static final int CREATE_AUTOINCREMENT = 0;
    public static final int MODIFY_AUTOINCREMENT_RESTART_VALUE = 1;
    public static final int MODIFY_AUTOINCREMENT_INC_VALUE = 2;

    @Override
    public void init(Object name, Object defaultNode, Object type, Object autoIncrementInfo) throws StandardException {
        super.init(name);
        this.type = (DataTypeDescriptor)type;
        if (!(defaultNode instanceof UntypedNullConstantNode)) {
            if (defaultNode instanceof GenerationClauseNode) {
                this.generationClauseNode = (GenerationClauseNode)defaultNode;
            } else {
                assert (defaultNode == null || defaultNode instanceof DefaultNode);
                this.defaultNode = (DefaultNode)defaultNode;
                if (autoIncrementInfo != null) {
                    long[] aii = (long[])autoIncrementInfo;
                    this.autoincrementStart = aii[0];
                    this.autoincrementIncrement = aii[1];
                    this.autoinc_create_or_modify_Start_Increment = aii[3];
                    this.autoincrementVerify = aii[2] <= 0L;
                    this.isAutoincrement = true;
                    if (type != null) {
                        this.setNullability(false);
                    }
                }
            }
        }
        this.keepCurrentDefault = defaultNode == null;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        ColumnDefinitionNode other = (ColumnDefinitionNode)node;
        this.isAutoincrement = other.isAutoincrement;
        this.type = other.type;
        this.defaultNode = (DefaultNode)this.getNodeFactory().copyNode(other.defaultNode, this.getParserContext());
        this.keepCurrentDefault = other.keepCurrentDefault;
        this.generationClauseNode = (GenerationClauseNode)this.getNodeFactory().copyNode(other.generationClauseNode, this.getParserContext());
        this.autoincrementIncrement = other.autoincrementIncrement;
        this.autoincrementStart = other.autoincrementStart;
        this.autoinc_create_or_modify_Start_Increment = other.autoinc_create_or_modify_Start_Increment;
        this.autoincrementVerify = other.autoincrementVerify;
    }

    @Override
    public String toString() {
        return "type: " + this.getType() + "\n" + (!this.isAutoincrementColumn() ? "" : "autoIncrementStart: " + this.getAutoincrementStart() + "\n" + "autoIncrementIncrement: " + this.getAutoincrementIncrement() + "\n") + super.toString();
    }

    public String getColumnName() {
        return this.name;
    }

    public final DataTypeDescriptor getType() {
        return this.type;
    }

    public void setType(DataTypeDescriptor dts) {
        this.type = dts;
    }

    void setNullability(boolean nullable) {
        this.type = this.getType().getNullabilityType(nullable);
    }

    public DefaultNode getDefaultNode() {
        return this.defaultNode;
    }

    public boolean hasGenerationClause() {
        return this.generationClauseNode != null;
    }

    public GenerationClauseNode getGenerationClauseNode() {
        return this.generationClauseNode;
    }

    public boolean isAutoincrementColumn() {
        return this.isAutoincrement;
    }

    public long getAutoincrementStart() {
        return this.autoincrementStart;
    }

    public long getAutoincrementIncrement() {
        return this.autoincrementIncrement;
    }

    public long getAutoinc_create_or_modify_Start_Increment() {
        return this.autoinc_create_or_modify_Start_Increment;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.defaultNode != null) {
            this.printLabel(depth, "default: ");
            this.defaultNode.treePrint(depth + 1);
        }
        if (this.generationClauseNode != null) {
            this.printLabel(depth, "generationClause: ");
            this.generationClauseNode.treePrint(depth + 1);
        }
    }
}

