/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.DDLStatementNode;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.TableElementList;
import com.akiban.sql.parser.Visitor;

public class AlterTableNode
extends DDLStatementNode {
    public TableElementList tableElementList = null;
    private boolean updateStatistics = false;
    private boolean updateStatisticsAll = false;
    private String indexNameForUpdateStatistics;
    public boolean compressTable = false;
    public boolean sequential = false;
    public boolean purge = false;
    public boolean defragment = false;
    public boolean truncateEndOfTable = false;
    public int behavior;
    private int changeType = 0;
    private boolean truncateTable = false;

    @Override
    public void init(Object objectName) throws StandardException {
        this.initAndCheck(objectName);
        this.truncateTable = true;
    }

    @Override
    public void init(Object objectName, Object updateStatisticsAll, Object indexName) throws StandardException {
        this.initAndCheck(objectName);
        this.updateStatisticsAll = (Boolean)updateStatisticsAll;
        this.indexNameForUpdateStatistics = (String)indexName;
        this.updateStatistics = true;
    }

    @Override
    public void init(Object objectName, Object sequential) throws StandardException {
        this.initAndCheck(objectName);
        this.sequential = (Boolean)sequential;
        this.compressTable = true;
    }

    @Override
    public void init(Object objectName, Object purge, Object defragment, Object truncateEndOfTable) throws StandardException {
        this.initAndCheck(objectName);
        this.purge = (Boolean)purge;
        this.defragment = (Boolean)defragment;
        this.truncateEndOfTable = (Boolean)truncateEndOfTable;
        this.compressTable = true;
    }

    @Override
    public void init(Object objectName, Object tableElementList, Object lockGranularity, Object changeType, Object behavior) throws StandardException {
        this.initAndCheck(objectName);
        this.tableElementList = (TableElementList)tableElementList;
        int[] ct = (int[])changeType;
        int[] bh = (int[])behavior;
        this.changeType = ct[0];
        this.behavior = bh[0];
        switch (this.changeType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new StandardException("Not implemented");
            }
        }
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        AlterTableNode other = (AlterTableNode)node;
        this.tableElementList = (TableElementList)this.getNodeFactory().copyNode(other.tableElementList, this.getParserContext());
        this.updateStatistics = other.updateStatistics;
        this.updateStatisticsAll = other.updateStatisticsAll;
        this.indexNameForUpdateStatistics = other.indexNameForUpdateStatistics;
        this.compressTable = other.compressTable;
        this.sequential = other.sequential;
        this.purge = other.purge;
        this.defragment = other.defragment;
        this.truncateEndOfTable = other.truncateEndOfTable;
        this.behavior = other.behavior;
        this.changeType = other.changeType;
        this.truncateTable = other.truncateTable;
    }

    @Override
    public String toString() {
        return super.toString() + "objectName: " + this.getObjectName() + "\n" + "compressTable: " + this.compressTable + "\n" + "sequential: " + this.sequential + "\n" + "truncateTable: " + this.truncateTable + "\n" + "purge: " + this.purge + "\n" + "defragment: " + this.defragment + "\n" + "truncateEndOfTable: " + this.truncateEndOfTable + "\n" + "updateStatistics: " + this.updateStatistics + "\n" + "updateStatisticsAll: " + this.updateStatisticsAll + "\n" + "indexNameForUpdateStatistics: " + this.indexNameForUpdateStatistics + "\n";
    }

    @Override
    public void printSubNodes(int depth) {
        if (this.tableElementList != null) {
            this.printLabel(depth, "tableElementList: ");
            this.tableElementList.treePrint(depth + 1);
        }
    }

    @Override
    public String statementToString() {
        if (this.truncateTable) {
            return "TRUNCATE TABLE";
        }
        return "ALTER TABLE";
    }

    public boolean isUpdateStatistics() {
        return this.updateStatistics;
    }

    public boolean isUpdateStatisticsAll() {
        return this.updateStatisticsAll;
    }

    public String getIndexNameForUpdateStatistics() {
        return this.indexNameForUpdateStatistics;
    }

    public boolean isCompressTable() {
        return this.compressTable;
    }

    public boolean isTruncateTable() {
        return this.truncateTable;
    }

    public int getChangeType() {
        return this.changeType;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.tableElementList != null) {
            this.tableElementList.accept(v);
        }
    }
}

