/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.compiler;

import com.akiban.sql.IncomparableException;
import com.akiban.sql.StandardException;
import com.akiban.sql.compiler.TypeCompiler;
import com.akiban.sql.parser.AggregateNode;
import com.akiban.sql.parser.BetweenOperatorNode;
import com.akiban.sql.parser.BinaryArithmeticOperatorNode;
import com.akiban.sql.parser.BinaryComparisonOperatorNode;
import com.akiban.sql.parser.BinaryLogicalOperatorNode;
import com.akiban.sql.parser.CoalesceFunctionNode;
import com.akiban.sql.parser.ColumnReference;
import com.akiban.sql.parser.ConcatenationOperatorNode;
import com.akiban.sql.parser.ConditionalNode;
import com.akiban.sql.parser.ExplicitCollateNode;
import com.akiban.sql.parser.FromSubquery;
import com.akiban.sql.parser.InListOperatorNode;
import com.akiban.sql.parser.InsertNode;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ResultColumn;
import com.akiban.sql.parser.ResultColumnList;
import com.akiban.sql.parser.RowConstructorNode;
import com.akiban.sql.parser.SelectNode;
import com.akiban.sql.parser.StatementNode;
import com.akiban.sql.parser.SubqueryNode;
import com.akiban.sql.parser.UnaryLogicalOperatorNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.ValueNodeList;
import com.akiban.sql.parser.Visitable;
import com.akiban.sql.parser.Visitor;
import com.akiban.sql.types.CharacterTypeAttributes;
import com.akiban.sql.types.DataTypeDescriptor;
import com.akiban.sql.types.TypeId;

public class TypeComputer
implements Visitor {
    public void compute(StatementNode stmt) throws StandardException {
        stmt.accept(this);
    }

    protected ValueNode setType(ValueNode node) throws StandardException {
        switch (node.getNodeType()) {
            case 145: {
                return this.collateNode((ExplicitCollateNode)node);
            }
        }
        node.setType(this.computeType(node));
        return node;
    }

    protected DataTypeDescriptor computeType(ValueNode node) throws StandardException {
        switch (node.getNodeType()) {
            case 80: {
                return this.resultColumn((ResultColumn)node);
            }
            case 39: 
            case 52: 
            case 111: {
                return this.binaryLogicalOperatorNode((BinaryLogicalOperatorNode)node);
            }
            case 26: {
                return this.unaryLogicalOperatorNode((UnaryLogicalOperatorNode)node);
            }
            case 40: 
            case 46: 
            case 48: 
            case 49: 
            case 79: {
                return this.binaryArithmeticOperatorNode((BinaryArithmeticOperatorNode)node);
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: {
                return this.binaryComparisonOperatorNode((BinaryComparisonOperatorNode)node);
            }
            case 53: {
                return this.betweenOperatorNode((BetweenOperatorNode)node);
            }
            case 55: {
                return this.inListOperatorNode((InListOperatorNode)node);
            }
            case 93: {
                return this.subqueryNode((SubqueryNode)node);
            }
            case 54: {
                return this.conditionalNode((ConditionalNode)node);
            }
            case 192: {
                return this.coalesceFunctionNode((CoalesceFunctionNode)node);
            }
            case 115: 
            case 167: {
                return this.aggregateNode((AggregateNode)node);
            }
            case 50: {
                return this.concatenationOperatorNode((ConcatenationOperatorNode)node);
            }
            case 24: 
            case 25: {
                return new DataTypeDescriptor(TypeId.BOOLEAN_ID, false);
            }
            case 231: {
                return new DataTypeDescriptor(TypeId.BIGINT_ID, false);
            }
            case 232: {
                return new DataTypeDescriptor(TypeId.BIGINT_ID, false);
            }
        }
        return null;
    }

    protected static boolean isParameterOrUntypedNull(ValueNode node) {
        switch (node.getNodeType()) {
            case 13: 
            case 88: {
                return true;
            }
        }
        return false;
    }

    protected DataTypeDescriptor resultColumn(ResultColumn node) throws StandardException {
        ColumnReference column;
        ValueNode expr = node.getExpression();
        if (expr == null) {
            return null;
        }
        if (TypeComputer.isParameterOrUntypedNull(expr) && expr.getType() == null && (column = node.getReference()) != null) {
            expr.setType(column.getType());
        }
        return expr.getType();
    }

    protected DataTypeDescriptor unaryLogicalOperatorNode(UnaryLogicalOperatorNode node) throws StandardException {
        ValueNode operand = node.getOperand();
        DataTypeDescriptor type = operand.getType();
        if (type != null && !type.getTypeId().isBooleanTypeId()) {
            type = new DataTypeDescriptor(TypeId.BOOLEAN_ID, type.isNullable());
            operand = (ValueNode)node.getNodeFactory().getNode(60, operand, type, node.getParserContext());
            node.setOperand(operand);
        }
        if (type == null && TypeComputer.isParameterOrUntypedNull(operand)) {
            type = new DataTypeDescriptor(TypeId.BOOLEAN_ID, true);
            operand.setType(type);
        }
        return type;
    }

    protected DataTypeDescriptor binaryLogicalOperatorNode(BinaryLogicalOperatorNode node) throws StandardException {
        ValueNode leftOperand = node.getLeftOperand();
        ValueNode rightOperand = node.getRightOperand();
        DataTypeDescriptor leftType = leftOperand.getType();
        DataTypeDescriptor rightType = rightOperand.getType();
        if (leftType != null && !leftType.getTypeId().isBooleanTypeId()) {
            leftType = new DataTypeDescriptor(TypeId.BOOLEAN_ID, leftType.isNullable());
            leftOperand = (ValueNode)node.getNodeFactory().getNode(60, leftOperand, leftType, node.getParserContext());
            node.setLeftOperand(leftOperand);
        }
        if (leftType == null && TypeComputer.isParameterOrUntypedNull(leftOperand)) {
            leftType = new DataTypeDescriptor(TypeId.BOOLEAN_ID, true);
            leftOperand.setType(leftType);
        }
        if (rightType != null && !rightType.getTypeId().isBooleanTypeId()) {
            rightType = new DataTypeDescriptor(TypeId.BOOLEAN_ID, rightType.isNullable());
            rightOperand = (ValueNode)node.getNodeFactory().getNode(60, rightOperand, rightType, node.getParserContext());
            node.setRightOperand(rightOperand);
        }
        if (rightType == null && TypeComputer.isParameterOrUntypedNull(rightOperand)) {
            rightType = new DataTypeDescriptor(TypeId.BOOLEAN_ID, true);
            rightOperand.setType(rightType);
        }
        if (node.getNodeType() == 111) {
            return new DataTypeDescriptor(TypeId.BOOLEAN_ID, false);
        }
        if (leftType == null) {
            return rightType;
        }
        if (rightType == null) {
            return leftType;
        }
        return leftType.getNullabilityType(leftType.isNullable() || rightType.isNullable());
    }

    protected DataTypeDescriptor binaryArithmeticOperatorNode(BinaryArithmeticOperatorNode node) throws StandardException {
        ValueNode leftOperand = node.getLeftOperand();
        ValueNode rightOperand = node.getRightOperand();
        DataTypeDescriptor leftType = leftOperand.getType();
        DataTypeDescriptor rightType = rightOperand.getType();
        if (TypeComputer.isParameterOrUntypedNull(leftOperand) && rightType != null) {
            leftType = rightType.getNullabilityType(true);
            leftOperand.setType(leftType);
        } else if (TypeComputer.isParameterOrUntypedNull(rightOperand) && leftType != null) {
            rightType = leftType.getNullabilityType(true);
            rightOperand.setType(rightType);
        }
        if (leftType == null || rightType == null) {
            return null;
        }
        TypeId leftTypeId = leftType.getTypeId();
        TypeId rightTypeId = rightType.getTypeId();
        if (leftTypeId.isStringTypeId() && rightTypeId.isNumericTypeId()) {
            boolean nullableResult = leftType.isNullable() || rightType.isNullable();
            int precision = rightType.getPrecision();
            int scale = rightType.getScale();
            int maxWidth = rightType.getMaximumWidth();
            if (rightTypeId.isDecimalTypeId()) {
                int charMaxWidth = leftType.getMaximumWidth();
                scale += charMaxWidth;
                maxWidth = (precision += 2 * charMaxWidth) + 3;
            }
            leftOperand = (ValueNode)node.getNodeFactory().getNode(60, leftOperand, new DataTypeDescriptor(rightTypeId, precision, scale, nullableResult, maxWidth), node.getParserContext());
            node.setLeftOperand(leftOperand);
        } else if (rightTypeId.isStringTypeId() && leftTypeId.isNumericTypeId()) {
            boolean nullableResult = leftType.isNullable() || rightType.isNullable();
            int precision = leftType.getPrecision();
            int scale = leftType.getScale();
            int maxWidth = leftType.getMaximumWidth();
            if (leftTypeId.isDecimalTypeId()) {
                int charMaxWidth = rightType.getMaximumWidth();
                scale += charMaxWidth;
                maxWidth = (precision += 2 * charMaxWidth) + 3;
            }
            rightOperand = (ValueNode)node.getNodeFactory().getNode(60, rightOperand, new DataTypeDescriptor(leftTypeId, precision, scale, nullableResult, maxWidth), node.getParserContext());
            node.setRightOperand(rightOperand);
        }
        return this.getTypeCompiler(leftOperand).resolveArithmeticOperation(leftOperand.getType(), rightOperand.getType(), node.getOperator());
    }

    protected DataTypeDescriptor binaryComparisonOperatorNode(BinaryComparisonOperatorNode node) throws StandardException {
        DataTypeDescriptor rightType;
        DataTypeDescriptor leftType;
        DataTypeDescriptor leftType2;
        ValueNode leftOperand = node.getLeftOperand();
        ValueNode rightOperand = node.getRightOperand();
        if (TypeComputer.isParameterOrUntypedNull(leftOperand)) {
            DataTypeDescriptor rightType2 = rightOperand.getType();
            if (rightType2 != null) {
                leftOperand.setType(rightType2.getNullabilityType(true));
            }
        } else if (TypeComputer.isParameterOrUntypedNull(rightOperand) && (leftType2 = leftOperand.getType()) != null) {
            rightOperand.setType(leftType2.getNullabilityType(true));
        }
        TypeId leftTypeId = leftOperand.getTypeId();
        TypeId rightTypeId = rightOperand.getTypeId();
        if (leftTypeId == null || rightTypeId == null) {
            return null;
        }
        if (!leftTypeId.isStringTypeId() && rightTypeId.isStringTypeId()) {
            leftType = leftOperand.getType();
            rightType = rightOperand.getType();
            rightOperand = (ValueNode)node.getNodeFactory().getNode(60, rightOperand, leftType.getNullabilityType(rightType.isNullable()), node.getParserContext());
            node.setRightOperand(rightOperand);
        } else if (!rightTypeId.isStringTypeId() && leftTypeId.isStringTypeId()) {
            leftType = leftOperand.getType();
            rightType = rightOperand.getType();
            leftOperand = (ValueNode)node.getNodeFactory().getNode(60, leftOperand, rightType.getNullabilityType(leftType.isNullable()), node.getParserContext());
            node.setLeftOperand(leftOperand);
        }
        if (!node.isForQueryRewrite()) {
            String operator2 = node.getOperator();
            boolean forEquals = operator2.equals("=") || operator2.equals("<>");
            boolean cmp = leftOperand.getType().comparable(rightOperand.getType(), forEquals);
            if (!cmp) {
                throw new IncomparableException("Types not comparable: " + leftOperand.getType().getTypeName() + " and " + rightOperand.getType().getTypeName());
            }
        }
        boolean nullableResult = leftOperand.getType().isNullable() || rightOperand.getType().isNullable();
        return new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullableResult);
    }

    protected DataTypeDescriptor betweenOperatorNode(BetweenOperatorNode node) throws StandardException {
        ValueNode leftOperand = node.getLeftOperand();
        DataTypeDescriptor leftType = leftOperand.getType();
        if (leftType == null) {
            return null;
        }
        ValueNodeList rightOperands = node.getRightOperandList();
        ValueNode lowOperand = (ValueNode)rightOperands.get(0);
        ValueNode highOperand = (ValueNode)rightOperands.get(1);
        if (TypeComputer.isParameterOrUntypedNull(lowOperand)) {
            lowOperand.setType(leftType.getNullabilityType(true));
        }
        if (TypeComputer.isParameterOrUntypedNull(highOperand)) {
            highOperand.setType(leftType.getNullabilityType(true));
        }
        TypeId leftTypeId = leftOperand.getTypeId();
        DataTypeDescriptor lowType = lowOperand.getType();
        DataTypeDescriptor highType = highOperand.getType();
        if (!leftTypeId.isStringTypeId()) {
            if (lowType != null && lowType.getTypeId().isStringTypeId()) {
                lowOperand = (ValueNode)node.getNodeFactory().getNode(60, lowOperand, leftType.getNullabilityType(lowType.isNullable()), node.getParserContext());
                rightOperands.set(0, lowOperand);
            }
            if (highType != null && highType.getTypeId().isStringTypeId()) {
                highOperand = (ValueNode)node.getNodeFactory().getNode(60, highOperand, leftType.getNullabilityType(highType.isNullable()), node.getParserContext());
                rightOperands.set(1, highOperand);
            }
        }
        if (lowType == null || highType == null) {
            return null;
        }
        boolean nullableResult = leftType.isNullable() || lowType.isNullable() || highType.isNullable();
        return new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullableResult);
    }

    protected DataTypeDescriptor inListOperatorNode(InListOperatorNode node) throws StandardException {
        RowConstructorNode leftOperand = node.getLeftOperand();
        if (leftOperand.getNodeList().size() == 1) {
            DataTypeDescriptor leftType = ((ValueNode)leftOperand.getNodeList().get(0)).getType();
            if (leftType == null) {
                return null;
            }
            boolean nullableResult = leftType.isNullable();
            for (ValueNode rightOperand : node.getRightOperandList().getNodeList()) {
                DataTypeDescriptor rightType;
                if (TypeComputer.isParameterOrUntypedNull(rightOperand)) {
                    rightType = leftType.getNullabilityType(true);
                    rightOperand.setType(rightType);
                } else {
                    rightType = rightOperand.getType();
                }
                if (rightType != null && !rightType.isNullable()) continue;
                nullableResult = true;
            }
            return new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullableResult);
        }
        boolean nullable = this.isNestedTupleNullable(leftOperand) || this.isNestedTupleNullable(node.getRightOperandList());
        return new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullable);
    }

    protected boolean isNestedTupleNullable(RowConstructorNode row) {
        boolean ret = false;
        for (ValueNode node : row.getNodeList()) {
            if (ret) {
                return ret;
            }
            if (node instanceof RowConstructorNode) {
                ret |= this.isNestedTupleNullable((RowConstructorNode)node);
                continue;
            }
            if (node.getType() == null) {
                ret = true;
                continue;
            }
            ret |= node.getType().isNullable();
        }
        return ret;
    }

    protected DataTypeDescriptor subqueryNode(SubqueryNode node) throws StandardException {
        if (node.getSubqueryType() == SubqueryNode.SubqueryType.EXPRESSION) {
            DataTypeDescriptor col1Type = ((ResultColumn)node.getResultSet().getResultColumns().get(0)).getType();
            if (col1Type == null) {
                return null;
            }
            return col1Type.getNullabilityType(true);
        }
        return new DataTypeDescriptor(TypeId.BOOLEAN_ID, true);
    }

    protected DataTypeDescriptor conditionalNode(ConditionalNode node) throws StandardException {
        this.checkBooleanClause(node.getTestCondition(), "WHEN");
        return this.dominantType(node.getThenElseList());
    }

    protected DataTypeDescriptor coalesceFunctionNode(CoalesceFunctionNode node) throws StandardException {
        return this.dominantType(node.getArgumentsList());
    }

    protected DataTypeDescriptor aggregateNode(AggregateNode node) throws StandardException {
        if (node.getAggregateName().equals("COUNT") || node.getAggregateName().equals("COUNT(*)")) {
            return new DataTypeDescriptor(TypeId.BIGINT_ID, false);
        }
        ValueNode operand = node.getOperand();
        if (operand == null || operand.getType() == null) {
            return null;
        }
        if (node.getAggregateName().equals("AVG") && operand.getType().getTypeId().isIntegerTypeId()) {
            return new DataTypeDescriptor(TypeId.DOUBLE_ID, true);
        }
        return operand.getType().getNullabilityType(true);
    }

    protected DataTypeDescriptor concatenationOperatorNode(ConcatenationOperatorNode node) throws StandardException {
        ValueNode leftOperand = node.getLeftOperand();
        ValueNode rightOperand = node.getRightOperand();
        DataTypeDescriptor leftType = leftOperand.getType();
        DataTypeDescriptor rightType = rightOperand.getType();
        if (leftType != null && !leftType.getTypeId().isStringTypeId()) {
            leftType = new DataTypeDescriptor(TypeId.VARCHAR_ID, leftType.isNullable(), leftType.getMaximumWidth());
            leftOperand = (ValueNode)node.getNodeFactory().getNode(60, leftOperand, leftType, node.getParserContext());
            node.setLeftOperand(leftOperand);
        } else if (TypeComputer.isParameterOrUntypedNull(leftOperand)) {
            leftType = new DataTypeDescriptor(TypeId.VARCHAR_ID, true);
            leftOperand.setType(leftType);
        }
        if (rightType != null && !rightType.getTypeId().isStringTypeId()) {
            rightType = new DataTypeDescriptor(TypeId.VARCHAR_ID, rightType.isNullable(), rightType.getMaximumWidth());
            rightOperand = (ValueNode)node.getNodeFactory().getNode(60, rightOperand, rightType, node.getParserContext());
            node.setRightOperand(rightOperand);
        } else if (TypeComputer.isParameterOrUntypedNull(rightOperand)) {
            rightType = new DataTypeDescriptor(TypeId.VARCHAR_ID, true);
            rightOperand.setType(rightType);
        }
        if (leftType == null || rightType == null) {
            return null;
        }
        return new DataTypeDescriptor(TypeId.VARCHAR_ID, leftType.isNullable() || rightType.isNullable(), leftType.getMaximumWidth() + rightType.getMaximumWidth(), CharacterTypeAttributes.mergeCollations(leftType.getCharacterAttributes(), rightType.getCharacterAttributes()));
    }

    protected ValueNode collateNode(ExplicitCollateNode node) throws StandardException {
        ValueNode operand = node.getOperand();
        DataTypeDescriptor origType = operand.getType();
        if (origType != null) {
            if (!origType.getTypeId().isStringTypeId()) {
                throw new StandardException("Collation not allowed for " + origType);
            }
            CharacterTypeAttributes characterAttributes = CharacterTypeAttributes.forCollation(origType.getCharacterAttributes(), node.getCollation());
            operand.setType(new DataTypeDescriptor(origType, characterAttributes));
        }
        return operand;
    }

    protected DataTypeDescriptor dominantType(ValueNodeList nodeList) throws StandardException {
        DataTypeDescriptor result = null;
        for (ValueNode node : nodeList) {
            if (node.getType() == null) continue;
            if (result == null) {
                result = node.getType();
                continue;
            }
            result = result.getDominantType(node.getType());
        }
        if (result != null) {
            for (int i = 0; i < nodeList.size(); ++i) {
                ValueNode node;
                node = (ValueNode)nodeList.get(i);
                if (TypeComputer.isParameterOrUntypedNull(node)) {
                    node.setType(result.getNullabilityType(true));
                    continue;
                }
                if (!this.addDominantCast(result, node.getType())) continue;
                node = (ValueNode)node.getNodeFactory().getNode(60, node, result.getNullabilityType(node.getType().isNullable()), node.getParserContext());
                nodeList.set(i, node);
            }
        }
        return result;
    }

    protected boolean addDominantCast(DataTypeDescriptor toType, DataTypeDescriptor fromType) {
        if (fromType == null) {
            return false;
        }
        if (toType.getTypeId().isStringTypeId()) {
            return !fromType.getTypeId().isStringTypeId();
        }
        return !fromType.getTypeId().equals(toType.getTypeId());
    }

    protected void selectNode(SelectNode node) throws StandardException {
        this.checkBooleanClause(node.getWhereClause(), "WHERE");
        this.checkBooleanClause(node.getHavingClause(), "HAVING");
        if (node.getResultColumns() != null) {
            node.getResultColumns().accept(this);
        }
    }

    private void checkBooleanClause(ValueNode clause, String which) throws StandardException {
        if (clause != null) {
            DataTypeDescriptor type = clause.getType();
            if (type == null) {
                assert (false) : "Type not set yet";
                return;
            }
            if (!type.getTypeId().isBooleanTypeId()) {
                throw new StandardException("Non-boolean " + which + " clause");
            }
        }
    }

    protected void fromSubquery(FromSubquery node) throws StandardException {
        if (node.getResultColumns() != null) {
            ResultColumnList rcl1 = node.getResultColumns();
            ResultColumnList rcl2 = node.getSubquery().getResultColumns();
            int size = rcl1.size();
            for (int i = 0; i < size; ++i) {
                ((ResultColumn)rcl1.get(i)).setType(((ResultColumn)rcl2.get(i)).getType());
            }
        }
    }

    protected void insertNode(InsertNode node) throws StandardException {
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            if (valueNode.getType() == null) {
                return this.setType(valueNode);
            }
        } else {
            switch (((QueryTreeNode)node).getNodeType()) {
                case 129: {
                    this.selectNode((SelectNode)node);
                    break;
                }
                case 136: {
                    this.fromSubquery((FromSubquery)node);
                    break;
                }
                case 138: {
                    this.insertNode((InsertNode)node);
                }
            }
        }
        return node;
    }

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return false;
    }

    @Override
    public boolean visitChildrenFirst(Visitable node) {
        return true;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    protected TypeCompiler getTypeCompiler(TypeId typeId) {
        return TypeCompiler.getTypeCompiler(typeId);
    }

    protected TypeCompiler getTypeCompiler(ValueNode valueNode) throws StandardException {
        return this.getTypeCompiler(valueNode.getTypeId());
    }
}

