/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.compiler;

import com.akiban.sql.StandardException;
import com.akiban.sql.compiler.BitTypeCompiler;
import com.akiban.sql.compiler.BooleanTypeCompiler;
import com.akiban.sql.compiler.CLOBTypeCompiler;
import com.akiban.sql.compiler.CharTypeCompiler;
import com.akiban.sql.compiler.DateTypeCompiler;
import com.akiban.sql.compiler.IntervalTypeCompiler;
import com.akiban.sql.compiler.LOBTypeCompiler;
import com.akiban.sql.compiler.NumericTypeCompiler;
import com.akiban.sql.compiler.RefTypeCompiler;
import com.akiban.sql.compiler.TimeTypeCompiler;
import com.akiban.sql.compiler.TimestampTypeCompiler;
import com.akiban.sql.compiler.UserDefinedTypeCompiler;
import com.akiban.sql.compiler.XMLTypeCompiler;
import com.akiban.sql.types.DataTypeDescriptor;
import com.akiban.sql.types.TypeId;

public abstract class TypeCompiler {
    public static final int LONGINT_MAXWIDTH_AS_CHAR = 20;
    public static final int INT_MAXWIDTH_AS_CHAR = 11;
    public static final int SMALLINT_MAXWIDTH_AS_CHAR = 6;
    public static final int TINYINT_MAXWIDTH_AS_CHAR = 4;
    public static final int DOUBLE_MAXWIDTH_AS_CHAR = 54;
    public static final int REAL_MAXWIDTH_AS_CHAR = 25;
    public static final int BOOLEAN_MAXWIDTH_AS_CHAR = 5;
    public static final String PLUS_OP = "+";
    public static final String DIVIDE_OP = "/";
    public static final String DIV_OP = "div";
    public static final String MINUS_OP = "-";
    public static final String TIMES_OP = "*";
    public static final String SUM_OP = "sum";
    public static final String AVG_OP = "avg";
    public static final String MOD_OP = "mod";
    private TypeId typeId;
    private static TypeCompiler bitTypeCompiler;
    private static TypeCompiler booleanTypeCompiler;
    private static TypeCompiler charTypeCompiler;
    private static TypeCompiler decimalTypeCompiler;
    private static TypeCompiler doubleTypeCompiler;
    private static TypeCompiler intTypeCompiler;
    private static TypeCompiler longintTypeCompiler;
    private static TypeCompiler longvarbitTypeCompiler;
    private static TypeCompiler longvarcharTypeCompiler;
    private static TypeCompiler realTypeCompiler;
    private static TypeCompiler smallintTypeCompiler;
    private static TypeCompiler tinyintTypeCompiler;
    private static TypeCompiler dateTypeCompiler;
    private static TypeCompiler timeTypeCompiler;
    private static TypeCompiler timestampTypeCompiler;
    private static TypeCompiler varbitTypeCompiler;
    private static TypeCompiler varcharTypeCompiler;
    private static TypeCompiler refTypeCompiler;
    private static TypeCompiler blobTypeCompiler;
    private static TypeCompiler clobTypeCompiler;
    private static TypeCompiler xmlTypeCompiler;
    private static TypeCompiler intervalMonthTypeCompiler;
    private static TypeCompiler intervalSecondTypeCompiler;

    protected TypeCompiler(TypeId typeId) {
        this.typeId = typeId;
    }

    public TypeId getTypeId() {
        return this.typeId;
    }

    public DataTypeDescriptor resolveArithmeticOperation(DataTypeDescriptor leftType, DataTypeDescriptor rightType, String operator2) throws StandardException {
        TypeId rightTypeId;
        TypeId leftTypeId = leftType.getTypeId();
        if (leftTypeId.equals(rightTypeId = rightType.getTypeId())) {
            return leftType;
        }
        throw new StandardException("Types not compatible for " + operator2 + ": " + leftTypeId.getSQLTypeName() + " and " + rightTypeId.getSQLTypeName());
    }

    public abstract boolean convertible(TypeId var1, boolean var2);

    protected boolean numberConvertible(TypeId otherType, boolean forDataTypeFunction) {
        boolean retval;
        if (otherType.isAnsiUDT()) {
            return false;
        }
        if (otherType.isLongConcatableTypeId()) {
            return false;
        }
        boolean bl = retval = otherType.isNumericTypeId() || otherType.userType();
        if (forDataTypeFunction) {
            retval = retval || otherType.isFixedStringTypeId() && this.getTypeId().isFloatingPointTypeId();
        }
        retval = retval || otherType.isFixedStringTypeId() && !this.getTypeId().isFloatingPointTypeId();
        return retval;
    }

    public abstract boolean compatible(TypeId var1);

    public abstract String getCorrespondingPrimitiveTypeName();

    public abstract String getPrimitiveMethodName();

    public abstract int getCastToCharWidth(DataTypeDescriptor var1);

    protected int getStoredFormatIdFromTypeId() {
        return this.getTypeId().getTypeFormatId();
    }

    public static TypeCompiler getTypeCompiler(TypeId typeId) {
        switch (typeId.getJDBCTypeId()) {
            case -2: {
                if (bitTypeCompiler == null) {
                    bitTypeCompiler = new BitTypeCompiler(typeId);
                }
                return bitTypeCompiler;
            }
            case -7: 
            case 16: {
                if (booleanTypeCompiler == null) {
                    booleanTypeCompiler = new BooleanTypeCompiler(typeId);
                }
                return booleanTypeCompiler;
            }
            case 1: {
                if (charTypeCompiler == null) {
                    charTypeCompiler = new CharTypeCompiler(typeId);
                }
                return charTypeCompiler;
            }
            case 2: 
            case 3: {
                if (decimalTypeCompiler == null) {
                    decimalTypeCompiler = new NumericTypeCompiler(typeId);
                }
                return decimalTypeCompiler;
            }
            case 8: {
                if (doubleTypeCompiler == null) {
                    doubleTypeCompiler = new NumericTypeCompiler(typeId);
                }
                return doubleTypeCompiler;
            }
            case 4: {
                if (intTypeCompiler == null) {
                    intTypeCompiler = new NumericTypeCompiler(typeId);
                }
                return intTypeCompiler;
            }
            case -5: {
                if (longintTypeCompiler == null) {
                    longintTypeCompiler = new NumericTypeCompiler(typeId);
                }
                return longintTypeCompiler;
            }
            case 2004: {
                if (blobTypeCompiler == null) {
                    blobTypeCompiler = new LOBTypeCompiler(typeId);
                }
                return blobTypeCompiler;
            }
            case -4: {
                if (longvarbitTypeCompiler == null) {
                    longvarbitTypeCompiler = new BitTypeCompiler(typeId);
                }
                return longvarbitTypeCompiler;
            }
            case 2005: {
                if (clobTypeCompiler == null) {
                    clobTypeCompiler = new CLOBTypeCompiler(typeId);
                }
                return clobTypeCompiler;
            }
            case -1: {
                if (longvarcharTypeCompiler == null) {
                    longvarcharTypeCompiler = new CharTypeCompiler(typeId);
                }
                return longvarcharTypeCompiler;
            }
            case 7: {
                if (realTypeCompiler == null) {
                    realTypeCompiler = new NumericTypeCompiler(typeId);
                }
                return realTypeCompiler;
            }
            case 5: {
                if (smallintTypeCompiler == null) {
                    smallintTypeCompiler = new NumericTypeCompiler(typeId);
                }
                return smallintTypeCompiler;
            }
            case -6: {
                if (tinyintTypeCompiler == null) {
                    tinyintTypeCompiler = new NumericTypeCompiler(typeId);
                }
                return tinyintTypeCompiler;
            }
            case 91: {
                if (dateTypeCompiler == null) {
                    dateTypeCompiler = new DateTypeCompiler(typeId);
                }
                return dateTypeCompiler;
            }
            case 92: {
                if (timeTypeCompiler == null) {
                    timeTypeCompiler = new TimeTypeCompiler(typeId);
                }
                return timeTypeCompiler;
            }
            case 93: {
                if (timestampTypeCompiler == null) {
                    timestampTypeCompiler = new TimestampTypeCompiler(typeId);
                }
                return timestampTypeCompiler;
            }
            case -3: {
                if (varbitTypeCompiler == null) {
                    varbitTypeCompiler = new BitTypeCompiler(typeId);
                }
                return varbitTypeCompiler;
            }
            case 12: {
                if (varcharTypeCompiler == null) {
                    varcharTypeCompiler = new CharTypeCompiler(typeId);
                }
                return varcharTypeCompiler;
            }
            case 1111: 
            case 2000: {
                if (typeId.isRefTypeId()) {
                    if (refTypeCompiler == null) {
                        refTypeCompiler = new RefTypeCompiler(typeId);
                    }
                    return refTypeCompiler;
                }
                if (typeId.isIntervalTypeId()) {
                    switch (typeId.getTypeFormatId()) {
                        case 24: {
                            if (intervalMonthTypeCompiler == null) {
                                intervalMonthTypeCompiler = new IntervalTypeCompiler(typeId);
                            }
                            return intervalMonthTypeCompiler;
                        }
                        case 25: {
                            if (intervalSecondTypeCompiler == null) {
                                intervalSecondTypeCompiler = new IntervalTypeCompiler(typeId);
                            }
                            return intervalSecondTypeCompiler;
                        }
                    }
                    return null;
                }
                return new UserDefinedTypeCompiler(typeId);
            }
            case 2009: {
                if (xmlTypeCompiler == null) {
                    xmlTypeCompiler = new XMLTypeCompiler(typeId);
                }
                return xmlTypeCompiler;
            }
        }
        assert (false) : "Unexpected JDBC type id " + typeId.getJDBCTypeId();
        return null;
    }
}

