/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.compiler;

import com.akiban.sql.StandardException;
import com.akiban.sql.compiler.TypeCompiler;
import com.akiban.sql.types.DataTypeDescriptor;
import com.akiban.sql.types.TypeId;

public class DateTypeCompiler
extends TypeCompiler {
    protected DateTypeCompiler(TypeId typeId) {
        super(typeId);
    }

    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        if (otherType.isStringTypeId() && !otherType.isLongConcatableTypeId()) {
            return true;
        }
        return this.getStoredFormatIdFromTypeId() == otherType.getTypeFormatId();
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "java.sql.Date";
    }

    @Override
    public String getPrimitiveMethodName() {
        return "getDate";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return 10;
    }

    @Override
    public DataTypeDescriptor resolveArithmeticOperation(DataTypeDescriptor leftType, DataTypeDescriptor rightType, String operator2) throws StandardException {
        boolean nullable;
        TypeId rightTypeId = rightType.getTypeId();
        boolean bl = nullable = leftType.isNullable() || rightType.isNullable();
        if (rightTypeId.isDateTimeTimeStampTypeId()) {
            if (operator2.equals("-")) {
                switch (rightTypeId.getTypeFormatId()) {
                    case 3: {
                        return new DataTypeDescriptor(TypeId.INTERVAL_DAY_ID, nullable);
                    }
                }
                return new DataTypeDescriptor(TypeId.INTERVAL_DAY_SECOND_ID, nullable);
            }
        } else if (rightTypeId.isIntervalTypeId() && (operator2.equals("+") || operator2.equals("-"))) {
            switch (rightTypeId.getTypeFormatId()) {
                case 24: {
                    return leftType.getNullabilityType(nullable);
                }
                case 25: {
                    if (rightTypeId != TypeId.INTERVAL_DAY_ID) break;
                    return leftType.getNullabilityType(nullable);
                }
            }
            return new DataTypeDescriptor(TypeId.TIMESTAMP_ID, nullable);
        }
        return super.resolveArithmeticOperation(leftType, rightType, operator2);
    }
}

