/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.ConnectionPool;
import com.coditory.sherlock.SqlConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;

class SingleConnectionPool
implements ConnectionPool {
    private final Connection connection;

    public SingleConnectionPool(Connection connection) {
        this.connection = Objects.requireNonNull(connection);
    }

    @Override
    public SqlConnection getConnection() {
        return new UncloseableConnection(this.connection);
    }

    static class UncloseableConnection
    implements SqlConnection {
        private final Connection connection;

        public UncloseableConnection(Connection connection) {
            this.connection = connection;
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.connection.prepareStatement(sql);
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.connection.createStatement();
        }

        @Override
        public void close() {
        }
    }
}

