/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.ConnectionPool;
import com.coditory.sherlock.SherlockException;
import com.coditory.sherlock.SqlConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import javax.sql.DataSource;

class DataSourceConnectionPool
implements ConnectionPool {
    private final DataSource dataSource;

    public DataSourceConnectionPool(DataSource dataSource) {
        this.dataSource = Objects.requireNonNull(dataSource);
    }

    @Override
    public SqlConnection getConnection() {
        try {
            return new DataSourceConnection(this.dataSource.getConnection());
        }
        catch (SQLException e) {
            throw new SherlockException("Could not obtain connection from a dataSource", (Throwable)e);
        }
    }

    static class DataSourceConnection
    implements SqlConnection {
        private final Connection connection;

        public DataSourceConnection(Connection connection) {
            this.connection = connection;
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.connection.prepareStatement(sql);
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.connection.createStatement();
        }

        @Override
        public void close() throws SQLException {
            this.connection.close();
        }
    }
}

