/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.DistributedLockConnector;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.Sherlock;
import com.coditory.sherlock.SherlockDefaults;
import com.coditory.sherlock.SherlockWithConnectorBuilder;
import com.coditory.sherlock.SqlDistributedLockConnector;
import java.sql.Connection;
import java.time.Clock;

public final class SqlSherlockBuilder
extends SherlockWithConnectorBuilder<SqlSherlockBuilder> {
    public static final String DEFAULT_LOCKS_TABLE_NAME = "locks";
    private String tableName = "locks";
    private Clock clock = SherlockDefaults.DEFAULT_CLOCK;
    private Connection connection;

    public static SqlSherlockBuilder sqlSherlock() {
        return new SqlSherlockBuilder();
    }

    public static Sherlock sqlSherlock(Connection connection) {
        return SqlSherlockBuilder.sqlSherlock().withConnection(connection).build();
    }

    private SqlSherlockBuilder() {
    }

    public SqlSherlockBuilder withConnection(Connection connection) {
        this.connection = (Connection)Preconditions.expectNonNull((Object)connection, (String)"Expected non null connection");
        return this;
    }

    public SqlSherlockBuilder withLocksTable(String tableName) {
        this.tableName = Preconditions.expectNonEmpty((String)tableName, (String)"Expected non empty tableName");
        return this;
    }

    public SqlSherlockBuilder withClock(Clock clock) {
        this.clock = (Clock)Preconditions.expectNonNull((Object)clock, (String)"Expected non null clock");
        return this;
    }

    public Sherlock build() {
        Preconditions.expectNonNull((Object)this.connection, (String)"Expected non null connection");
        SqlDistributedLockConnector connector = new SqlDistributedLockConnector(this.connection, this.tableName, this.clock);
        return super.build((DistributedLockConnector)connector);
    }
}

