/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.Preconditions;
import java.time.Duration;
import java.util.Objects;

final class LockDuration {
    private final Duration duration;

    static LockDuration of(Duration duration) {
        return new LockDuration(duration);
    }

    static LockDuration permanent() {
        return new LockDuration(null);
    }

    private LockDuration(Duration duration) {
        if (duration != null) {
            Preconditions.expectTruncatedToMillis(duration, "Expected lock duration truncated to millis. Got: " + duration);
        }
        this.duration = duration;
    }

    Duration getValue() {
        return this.duration;
    }

    boolean isPermanent() {
        return this.duration == null;
    }

    public String toString() {
        return "LockDuration(" + this.duration + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockDuration that = (LockDuration)o;
        return Objects.equals(this.duration, that.duration);
    }

    public int hashCode() {
        return Objects.hash(this.duration);
    }
}

