/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.DelegatingDistributedLock;
import com.coditory.sherlock.DistributedLock;
import com.coditory.sherlock.DistributedLockBuilder;
import com.coditory.sherlock.DistributedLockConnector;
import com.coditory.sherlock.LockDuration;
import com.coditory.sherlock.LockId;
import com.coditory.sherlock.OwnerId;
import com.coditory.sherlock.OwnerIdPolicy;
import com.coditory.sherlock.Sherlock;
import com.coditory.sherlock.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SherlockWithConnector
implements Sherlock {
    private final Logger logger = LoggerFactory.getLogger(SherlockWithConnector.class);
    private final DistributedLockConnector connector;
    private final LockDuration defaultDuration;
    private final OwnerIdPolicy defaultOwnerIdPolicy;

    SherlockWithConnector(DistributedLockConnector connector, OwnerIdPolicy defaultOwnerIdPolicy, LockDuration defaultDuration) {
        this.connector = (DistributedLockConnector)Preconditions.expectNonNull((Object)connector, (String)"Expected non null connector");
        this.defaultOwnerIdPolicy = (OwnerIdPolicy)Preconditions.expectNonNull((Object)defaultOwnerIdPolicy, (String)"Expected non null defaultOwnerIdPolicy");
        this.defaultDuration = (LockDuration)Preconditions.expectNonNull((Object)defaultDuration, (String)"Expected non null defaultDuration");
    }

    @Override
    public void initialize() {
        this.logger.debug("Initializing sherlock infrastructure");
        this.connector.initialize();
    }

    @Override
    public DistributedLockBuilder<DistributedLock> createLock() {
        return this.createLockBuilder(this.connector::acquire, this.connector::release);
    }

    @Override
    public DistributedLockBuilder<DistributedLock> createReentrantLock() {
        return this.createLockBuilder(this.connector::acquireOrProlong, this.connector::release);
    }

    @Override
    public DistributedLockBuilder<DistributedLock> createOverridingLock() {
        return this.createLockBuilder(this.connector::forceAcquire, (id, __) -> this.connector.forceRelease(id));
    }

    @Override
    public boolean forceReleaseAllLocks() {
        return this.connector.forceReleaseAll();
    }

    private DistributedLockBuilder<DistributedLock> createLockBuilder(DelegatingDistributedLock.AcquireAction acquireAction, DelegatingDistributedLock.ReleaseAction releaseAction) {
        return new DistributedLockBuilder(this.createLock(acquireAction, releaseAction)).withLockDuration(this.defaultDuration).withOwnerIdPolicy(this.defaultOwnerIdPolicy);
    }

    private DistributedLockBuilder.LockCreator<DistributedLock> createLock(DelegatingDistributedLock.AcquireAction acquireAction, DelegatingDistributedLock.ReleaseAction releaseAction) {
        return (lockId, duration, ownerId) -> this.createLockAndLog(acquireAction, releaseAction, lockId, ownerId, duration);
    }

    private DistributedLock createLockAndLog(DelegatingDistributedLock.AcquireAction acquireAction, DelegatingDistributedLock.ReleaseAction releaseAction, LockId lockId, OwnerId ownerId, LockDuration duration) {
        DelegatingDistributedLock lock = new DelegatingDistributedLock(acquireAction, releaseAction, lockId, ownerId, duration);
        this.logger.debug("Created lock: {}", (Object)lock);
        return lock;
    }
}

