/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.gradle.webjar;

import com.coditory.gradle.webjar.WebjarRemoveModulesTask;
import com.coditory.gradle.webjar.shared.VersionFiles;
import com.github.gradle.node.NodeExtension;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/coditory/gradle/webjar/WebjarRemoveModulesTask;", "", "()V", "install", "", "project", "Lorg/gradle/api/Project;", "normalizeVersion", "", "value", "removeNpmModules", "removeStaleNpmModules", "logger", "Lorg/gradle/api/logging/Logger;", "webjar-plugin"})
public final class WebjarRemoveModulesTask {
    @NotNull
    public static final WebjarRemoveModulesTask INSTANCE;

    public final void install(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getTasks().register("webjarRemoveModules", (Action)install.1.INSTANCE);
    }

    private final void removeStaleNpmModules(Project project, Logger logger) {
        boolean versionChanged;
        NodeExtension node = (NodeExtension)project.getExtensions().findByType(NodeExtension.class);
        NodeExtension nodeExtension = node;
        String nodeVersion = this.normalizeVersion(nodeExtension != null && (nodeExtension = nodeExtension.getVersion()) != null ? (String)nodeExtension.getOrNull() : null);
        NodeExtension nodeExtension2 = node;
        String npmVersion = this.normalizeVersion(nodeExtension2 != null && (nodeExtension2 = nodeExtension2.getNpmVersion()) != null ? (String)nodeExtension2.getOrNull() : null);
        String lastNodeVersion = VersionFiles.INSTANCE.nodeVersionFile(project).read();
        String lastNpmVersion = VersionFiles.INSTANCE.npmVersionFile(project).read();
        boolean bl = versionChanged = Intrinsics.areEqual((Object)lastNodeVersion, (Object)nodeVersion) ^ true || Intrinsics.areEqual((Object)lastNpmVersion, (Object)npmVersion) ^ true;
        if (versionChanged) {
            logger.warn("Node/NPM version changed - removing node_modules in order to rebuild dependencies");
            logger.warn("  Node detected: " + lastNodeVersion + ", expected: " + nodeVersion);
            logger.warn("  NPM  detected: " + lastNpmVersion + ", expected: " + npmVersion);
            this.removeNpmModules(project);
        }
    }

    private final String normalizeVersion(String value) {
        CharSequence charSequence = value;
        boolean bl = false;
        boolean bl2 = false;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "undefined" : value;
    }

    private final void removeNpmModules(Project project) {
        File file = project.getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
        File nodeModulesDir = FilesKt.resolve((File)file, (String)"node_modules");
        FilesKt.deleteRecursively((File)nodeModulesDir);
        nodeModulesDir.mkdirs();
    }

    private WebjarRemoveModulesTask() {
    }

    static {
        WebjarRemoveModulesTask webjarRemoveModulesTask;
        INSTANCE = webjarRemoveModulesTask = new WebjarRemoveModulesTask();
    }

    public static final /* synthetic */ void access$removeStaleNpmModules(WebjarRemoveModulesTask $this, Project project, Logger logger) {
        $this.removeStaleNpmModules(project, logger);
    }
}

