/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.gradle.webjar;

import com.coditory.gradle.webjar.WebjarExtension;
import com.coditory.gradle.webjar.WebjarSkipCondition;
import com.coditory.gradle.webjar.shared.TimeMarkers;
import com.github.gradle.node.npm.task.NpmTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\f"}, d2={"Lcom/coditory/gradle/webjar/WebjarLintTask;", "", "()V", "install", "", "project", "Lorg/gradle/api/Project;", "webjar", "Lcom/coditory/gradle/webjar/WebjarExtension;", "setupCache", "task", "Lcom/github/gradle/node/npm/task/NpmTask;", "webjar-plugin"})
public final class WebjarLintTask {
    @NotNull
    public static final WebjarLintTask INSTANCE;

    public final void install(@NotNull Project project, @NotNull WebjarExtension webjar) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)webjar, (String)"webjar");
        TaskProvider lintTask2 = project.getTasks().register("webjarLint", NpmTask.class, (Action)new Action<NpmTask>(webjar, project){
            final /* synthetic */ WebjarExtension $webjar;
            final /* synthetic */ Project $project;

            public final void execute(NpmTask task) {
                task.dependsOn(new Object[]{"webjarInstall"});
                NpmTask npmTask = task;
                Intrinsics.checkNotNullExpressionValue((Object)npmTask, (String)"task");
                npmTask.setGroup("webjar");
                task.getArgs().set((Iterable)CollectionsKt.listOf((Object[])new String[]{"run", this.$webjar.getTaskNames().getLint()}));
                if (this.$webjar.getCache().getEnabled() && this.$webjar.getCache().getCacheLint()) {
                    WebjarLintTask.access$setupCache(WebjarLintTask.INSTANCE, task, this.$project, this.$webjar);
                }
            }
            {
                this.$webjar = webjarExtension;
                this.$project = project;
            }
        });
        if (!WebjarSkipCondition.INSTANCE.isWebjarSkipped(project)) {
            project.getTasks().named("check").configure((Action)new Action<Task>(lintTask2){
                final /* synthetic */ TaskProvider $lintTask;

                public final void execute(Task it) {
                    it.dependsOn(new Object[]{this.$lintTask});
                }
                {
                    this.$lintTask = taskProvider;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setupCache(NpmTask task, Project project, WebjarExtension webjar) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = webjar.getCache().getSrc();
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = project.getProjectDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
            File file2 = FilesKt.resolve((File)file, (String)it);
            collection.add(file2);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.isDirectory()) {
                task.getInputs().dir((Object)it);
                continue;
            }
            if (!it.isFile()) continue;
            task.getInputs().file((Object)it);
        }
        task.getInputs().files(new Object[]{".eslintrc", ".eslintignore", "package.json"});
        TaskOutputsInternal taskOutputsInternal = task.getOutputs();
        File file = project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
        taskOutputsInternal.file((Object)FilesKt.resolve((File)file, (String)webjar.getCache().getLintTimestampFile()));
        task.doLast((Action)new Action<Task>(project, webjar){
            final /* synthetic */ Project $project;
            final /* synthetic */ WebjarExtension $webjar;

            public final void execute(Task it) {
                TimeMarkers.createTimeMarkerFile$default(TimeMarkers.INSTANCE, this.$project, this.$webjar.getCache().getLintTimestampFile(), null, 4, null);
            }
            {
                this.$project = project;
                this.$webjar = webjarExtension;
            }
        });
    }

    private WebjarLintTask() {
    }

    static {
        WebjarLintTask webjarLintTask;
        INSTANCE = webjarLintTask = new WebjarLintTask();
    }

    public static final /* synthetic */ void access$setupCache(WebjarLintTask $this, NpmTask task, Project project, WebjarExtension webjar) {
        $this.setupCache(task, project, webjar);
    }
}

