/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.gradle.webjar;

import com.coditory.gradle.webjar.WebjarInitTask;
import com.coditory.gradle.webjar.shared.SemVersion;
import com.github.gradle.node.NodeExtension;
import com.github.gradle.node.npm.task.NpmTask;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/coditory/gradle/webjar/WebjarInitTask;", "", "()V", "ensurePackageJson", "", "project", "Lorg/gradle/api/Project;", "install", "resolveNpmArguments", "", "", "setupCaching", "task", "Lcom/github/gradle/node/npm/task/NpmTask;", "webjar-plugin"})
public final class WebjarInitTask {
    @NotNull
    public static final WebjarInitTask INSTANCE;

    public final void install(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getTasks().register("webjarInit", NpmTask.class, (Action)new Action<NpmTask>(project){
            final /* synthetic */ Project $project;

            public final void execute(NpmTask task) {
                task.dependsOn(new Object[]{"npmSetup"});
                task.dependsOn(new Object[]{"webjarRemoveModules"});
                NpmTask npmTask = task;
                Intrinsics.checkNotNullExpressionValue((Object)npmTask, (String)"task");
                npmTask.setGroup("webjar");
                task.getArgs().set((Iterable)WebjarInitTask.access$resolveNpmArguments(WebjarInitTask.INSTANCE, this.$project));
                task.doFirst((Action)new Action<Task>(this){
                    final /* synthetic */ install.1 this$0;

                    public final void execute(Task it) {
                        WebjarInitTask.access$ensurePackageJson(WebjarInitTask.INSTANCE, this.this$0.$project);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                WebjarInitTask.access$setupCaching(WebjarInitTask.INSTANCE, task);
            }
            {
                this.$project = project;
            }
        });
    }

    private final void setupCaching(NpmTask task) {
        task.getInputs().files(new Object[]{"package.json"});
        task.getOutputs().file((Object)"package-lock.json");
    }

    private final List<String> resolveNpmArguments(Project project) {
        NodeExtension node = (NodeExtension)project.getExtensions().findByType(NodeExtension.class);
        NodeExtension nodeExtension = node;
        SemVersion npmSemVersion = SemVersion.Companion.parseOrNull(nodeExtension != null && (nodeExtension = nodeExtension.getNpmVersion()) != null ? (String)nodeExtension.getOrNull() : null);
        return npmSemVersion == null || npmSemVersion.compareTo(SemVersion.Companion.parse("6.0.0")) >= 0 ? CollectionsKt.listOf((Object[])new String[]{"install", "--package-lock-only"}) : CollectionsKt.listOf((Object)"install");
    }

    private final void ensurePackageJson(Project project) {
        File file = project.getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
        File packageJsonFile = FilesKt.resolve((File)file, (String)"package.json");
        if (!packageJsonFile.isFile()) {
            packageJsonFile.createNewFile();
            FilesKt.writeText$default((File)packageJsonFile, (String)StringsKt.trimIndent((String)("\n                {\n                    \"name\": \"" + project.getName() + "\",\n                    \"scripts\": {\n                        \"lint\": \"echo 'missing lint script'\",\n                        \"test\": \"echo 'missing test script'\",\n                        \"clean\": \"echo 'missing clean script'\",\n                        \"build\": \"echo 'missing build script'\",\n                        \"watch\": \"echo 'missing watch script'\"\n                    }\n                }\n                ")), null, (int)2, null);
        }
    }

    private WebjarInitTask() {
    }

    static {
        WebjarInitTask webjarInitTask;
        INSTANCE = webjarInitTask = new WebjarInitTask();
    }

    public static final /* synthetic */ List access$resolveNpmArguments(WebjarInitTask $this, Project project) {
        return $this.resolveNpmArguments(project);
    }

    public static final /* synthetic */ void access$ensurePackageJson(WebjarInitTask $this, Project project) {
        $this.ensurePackageJson(project);
    }

    public static final /* synthetic */ void access$setupCaching(WebjarInitTask $this, NpmTask task) {
        $this.setupCaching(task);
    }
}

