/*
 * Decompiled with CFR 0.152.
 */
package com.codingrodent.jackson.crypto;

import com.codingrodent.jackson.crypto.EncryptedDeserializerModifier;
import com.codingrodent.jackson.crypto.EncryptedSerializerModifier;
import com.codingrodent.jackson.crypto.EncryptionException;
import com.codingrodent.jackson.crypto.EncryptionService;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.util.ResourceBundle;

public class CryptoModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    public static final String GROUP_ID = "com.codingrodent.jackson.crypto";
    public static final String ARTIFACT_ID = "jackson-json-crypto";
    private static final String BUNDLE = CryptoModule.class.getPackage().getName() + ".config";
    private final int major;
    private final int minor;
    private final int patch;
    private transient EncryptedSerializerModifier serializerModifierModifier;
    private transient EncryptedDeserializerModifier deserializerModifierModifier;

    public CryptoModule() {
        ResourceBundle rb = ResourceBundle.getBundle(BUNDLE);
        this.major = Integer.parseInt(rb.getString("projectVersionMajor"));
        this.minor = Integer.parseInt(rb.getString("projectVersionMinor"));
        this.patch = Integer.parseInt(rb.getString("projectVersionBuild"));
    }

    public CryptoModule addEncryptionService(EncryptionService encryptionService) {
        this.serializerModifierModifier = new EncryptedSerializerModifier(encryptionService);
        this.deserializerModifierModifier = new EncryptedDeserializerModifier(encryptionService);
        return this;
    }

    public String getModuleName() {
        return ARTIFACT_ID;
    }

    public Version version() {
        return new Version(this.major, this.minor, this.patch, null, GROUP_ID, ARTIFACT_ID);
    }

    public void setupModule(Module.SetupContext context) {
        if (null == this.serializerModifierModifier || null == this.deserializerModifierModifier) {
            throw new EncryptionException("Crypto module not initialised with an encryption service");
        }
        context.addBeanSerializerModifier((BeanSerializerModifier)this.serializerModifierModifier);
        context.addBeanDeserializerModifier((BeanDeserializerModifier)this.deserializerModifierModifier);
    }
}

