/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tracing.http.ribbon;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.txlcn.tracing.TracingContext;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.serviceregistry.Registration;

public class TxlcnZoneAvoidanceRule
extends ZoneAvoidanceRule {
    private static final Logger log = LoggerFactory.getLogger(TxlcnZoneAvoidanceRule.class);
    private final Registration registration;

    public TxlcnZoneAvoidanceRule() {
        this.registration = null;
    }

    TxlcnZoneAvoidanceRule(Registration registration) {
        this.registration = registration;
    }

    public Server choose(Object key) {
        if (!TracingContext.tracing().hasGroup()) {
            return super.choose(key);
        }
        assert (Objects.nonNull(this.registration));
        TracingContext.tracing().addApp(this.registration.getServiceId(), this.registration.getHost() + ":" + this.registration.getPort());
        List servers = this.getLoadBalancer().getAllServers();
        assert (!servers.isEmpty());
        JSONObject appMap = TracingContext.tracing().appMap();
        log.debug("load balanced rule servers: {}, txGroup[{}]'s server map:{}", new Object[]{servers, TracingContext.tracing().groupId(), appMap});
        Server balanceServer = null;
        String serviceId = ((Server)servers.get(0)).getMetaInfo().getAppName();
        if (appMap.containsKey((Object)serviceId)) {
            for (Server server : servers) {
                if (!server.getHostPort().equals(appMap.getString(serviceId))) continue;
                log.debug("txlcn chosen server [{}] in txGroup: {}", (Object)server, (Object)TracingContext.tracing().groupId());
                balanceServer = server;
            }
        }
        if (Objects.isNull(balanceServer)) {
            Server server = super.choose(key);
            TracingContext.tracing().addApp(server.getMetaInfo().getAppName(), server.getHostPort());
            return server;
        }
        return balanceServer;
    }
}

