/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.txmsg;

import com.codingapi.txlcn.common.util.Transactions;
import com.codingapi.txlcn.common.util.id.ModIdProvider;
import com.codingapi.txlcn.tc.config.TxClientConfig;
import com.codingapi.txlcn.tc.txmsg.ReliableMessenger;
import com.codingapi.txlcn.txmsg.RpcClientInitializer;
import com.codingapi.txlcn.txmsg.dto.TxManagerHost;
import com.codingapi.txlcn.txmsg.exception.RpcException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TMSearcher {
    private static final Logger log = LoggerFactory.getLogger(TMSearcher.class);
    private static RpcClientInitializer RPC_CLIENT_INITIALIZER;
    private static ReliableMessenger RELIABLE_MESSENGER;
    private static volatile CountDownLatch clusterCountLatch;
    private static int knownTMClusterSize;

    @Autowired
    public TMSearcher(RpcClientInitializer rpcClientInitializer, TxClientConfig clientConfig, ReliableMessenger reliableMessenger, ModIdProvider modIdProvider) {
        Transactions.setApplicationIdWhenRunning((String)modIdProvider.modId());
        RPC_CLIENT_INITIALIZER = rpcClientInitializer;
        RELIABLE_MESSENGER = reliableMessenger;
        knownTMClusterSize = clientConfig.getManagerAddress().size();
    }

    public static void search() {
        Objects.requireNonNull(RPC_CLIENT_INITIALIZER);
        log.info("Searching for more TM...");
        try {
            HashSet<String> cluster = RELIABLE_MESSENGER.queryTMCluster();
            if (cluster.isEmpty()) {
                log.info("No more TM.");
                TMSearcher.echoTMClusterSuccessful();
                return;
            }
            clusterCountLatch = new CountDownLatch(cluster.size() - knownTMClusterSize);
            log.debug("wait connect size is {}", (Object)(cluster.size() - knownTMClusterSize));
            RPC_CLIENT_INITIALIZER.init(TxManagerHost.parserList(new ArrayList<String>(cluster)), true);
            clusterCountLatch.await(10L, TimeUnit.SECONDS);
            TMSearcher.echoTMClusterSuccessful();
        }
        catch (RpcException | InterruptedException e) {
            throw new IllegalStateException("There is no normal TM.");
        }
    }

    public static boolean searchedOne() {
        if (Objects.nonNull(clusterCountLatch)) {
            if (clusterCountLatch.getCount() == 0L) {
                return false;
            }
            clusterCountLatch.countDown();
            return true;
        }
        return false;
    }

    private static void echoTMClusterSuccessful() {
        log.info("TC[{}] established TM cluster successfully!", (Object)Transactions.APPLICATION_ID_WHEN_RUNNING);
        TMSearcher.echoTmClusterSize();
    }

    public static void echoTmClusterSize() {
        log.info("TM cluster's size: {}", (Object)RELIABLE_MESSENGER.clusterSize());
    }

    static {
        knownTMClusterSize = 1;
    }
}

