/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.support.p6spy.common;

import com.codingapi.txlcn.tc.support.p6spy.common.ConnectionInformation;
import com.codingapi.txlcn.tc.support.p6spy.common.Loggable;
import com.codingapi.txlcn.tc.support.p6spy.common.StatementInformation;
import com.codingapi.txlcn.tc.support.p6spy.common.Value;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResultSetInformation
implements Loggable {
    private final StatementInformation statementInformation;
    private String query;
    private final Map<String, Value> resultMap = new LinkedHashMap<String, Value>();
    private int currRow = -1;
    private int lastRowLogged = -1;

    public ResultSetInformation(StatementInformation statementInformation) {
        this.statementInformation = statementInformation;
        this.query = statementInformation.getStatementQuery();
    }

    public void generateLogMessage() {
        if (this.lastRowLogged != this.currRow) {
            this.resultMap.clear();
            this.lastRowLogged = this.currRow;
        }
    }

    public int getCurrRow() {
        return this.currRow;
    }

    public void incrementCurrRow() {
        ++this.currRow;
    }

    public void setColumnValue(String columnName, Object value) {
        this.resultMap.put(columnName, new Value(value));
    }

    @Override
    public String getSql() {
        return this.query;
    }

    @Override
    public String getSqlWithValues() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Value> entry : this.resultMap.entrySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(entry.getKey());
            sb.append(" = ");
            sb.append(entry.getValue() != null ? entry.getValue().toString() : new Value().toString());
        }
        return sb.toString();
    }

    public StatementInformation getStatementInformation() {
        return this.statementInformation;
    }

    @Override
    public ConnectionInformation getConnectionInformation() {
        return this.statementInformation.getConnectionInformation();
    }
}

