/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.transaction.txc.analy;

import com.codingapi.txlcn.tc.core.DTXLocalContext;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.TableStruct;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TableStructAnalyser {
    private final DataSource dataSource;

    @Autowired
    public TableStructAnalyser(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public TableStruct analyse(Connection connection, String table) throws SQLException {
        ResultSet structRs = null;
        ResultSet columnSet = null;
        TableStruct tableStruct = new TableStruct(table);
        try {
            structRs = connection.getMetaData().getPrimaryKeys(connection.getCatalog(), null, table);
            columnSet = connection.getMetaData().getColumns(null, "%", table, "%");
            while (structRs.next()) {
                tableStruct.getPrimaryKeys().add(structRs.getString("COLUMN_NAME"));
            }
            while (columnSet.next()) {
                tableStruct.getColumns().put(columnSet.getString("COLUMN_NAME"), columnSet.getString("TYPE_NAME"));
            }
        }
        catch (SQLException e) {
            try {
                DbUtils.close(structRs);
                DbUtils.close(columnSet);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
        return tableStruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableStruct analyse(String table) throws SQLException {
        Connection connection = null;
        try {
            DTXLocalContext.makeUnProxy();
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(true);
            TableStruct tableStruct = this.analyse(connection, table);
            return tableStruct;
        }
        finally {
            DTXLocalContext.undoProxyStatus();
            DbUtils.close((Connection)connection);
        }
    }

    public boolean existsTable(Connection connection, String table) throws SQLException {
        ResultSet resultSet;
        block4: {
            boolean bl;
            resultSet = null;
            try {
                resultSet = connection.getMetaData().getTables(null, null, table, null);
                if (!resultSet.next()) break block4;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    DbUtils.close(resultSet);
                    throw throwable;
                }
            }
            DbUtils.close((ResultSet)resultSet);
            return bl;
        }
        DbUtils.close((ResultSet)resultSet);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsTable(String tableName) throws SQLException {
        boolean bl;
        Connection connection = null;
        try {
            DTXLocalContext.makeUnProxy();
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(true);
            bl = this.existsTable(connection, tableName);
        }
        catch (Throwable throwable) {
            DbUtils.close(connection);
            DTXLocalContext.undoProxyStatus();
            throw throwable;
        }
        DbUtils.close((Connection)connection);
        DTXLocalContext.undoProxyStatus();
        return bl;
    }
}

