/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.aspect.weave;

import com.codingapi.txlcn.tc.aspect.DTXInfo;
import com.codingapi.txlcn.tc.aspect.weave.BusinessCallback;
import com.codingapi.txlcn.tc.core.DTXLocalContext;
import com.codingapi.txlcn.tc.core.DTXServiceExecutor;
import com.codingapi.txlcn.tc.core.TxTransactionInfo;
import com.codingapi.txlcn.tc.core.context.TCGlobalContext;
import com.codingapi.txlcn.tc.core.context.TxContext;
import com.codingapi.txlcn.tracing.TracingContext;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DTXLogicWeaver {
    private static final Logger log = LoggerFactory.getLogger(DTXLogicWeaver.class);
    private final DTXServiceExecutor transactionServiceExecutor;
    private final TCGlobalContext globalContext;

    @Autowired
    public DTXLogicWeaver(DTXServiceExecutor transactionServiceExecutor, TCGlobalContext globalContext) {
        this.transactionServiceExecutor = transactionServiceExecutor;
        this.globalContext = globalContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runTransaction(DTXInfo dtxInfo, BusinessCallback business) throws Throwable {
        TxContext txContext;
        if (!Objects.isNull(DTXLocalContext.cur())) {
            return business.call();
        }
        DTXLocalContext.getOrNew();
        log.debug("<---- TxLcn start ---->");
        DTXLocalContext dtxLocalContext = DTXLocalContext.getOrNew();
        if (this.globalContext.hasTxContext()) {
            txContext = this.globalContext.txContext();
            dtxLocalContext.setInGroup(true);
            log.debug("Unit[{}] used parent's TxContext[{}].", (Object)dtxInfo.getUnitId(), (Object)txContext.getGroupId());
        } else {
            txContext = this.globalContext.startTx();
        }
        if (Objects.nonNull(dtxLocalContext.getGroupId())) {
            dtxLocalContext.setDestroy(false);
        }
        dtxLocalContext.setUnitId(dtxInfo.getUnitId());
        dtxLocalContext.setGroupId(txContext.getGroupId());
        dtxLocalContext.setTransactionType(dtxInfo.getTransactionType());
        TxTransactionInfo info = new TxTransactionInfo();
        info.setBusinessCallback(business);
        info.setGroupId(txContext.getGroupId());
        info.setUnitId(dtxInfo.getUnitId());
        info.setPointMethod(dtxInfo.getBusinessMethod());
        info.setPropagation(dtxInfo.getTransactionPropagation());
        info.setTransactionInfo(dtxInfo.getTransactionInfo());
        info.setTransactionType(dtxInfo.getTransactionType());
        info.setTransactionStart(txContext.isDtxStart());
        try {
            Object object = this.transactionServiceExecutor.transactionRunning(info);
            return object;
        }
        finally {
            if (dtxLocalContext.isDestroy()) {
                Object object = txContext.getLock();
                synchronized (object) {
                    txContext.getLock().notifyAll();
                }
                if (!dtxLocalContext.isInGroup()) {
                    this.globalContext.destroyTx();
                }
                DTXLocalContext.makeNeverAppeared();
                TracingContext.tracing().destroy();
            }
            log.debug("<---- TxLcn end ---->");
        }
    }
}

