/*
 * Decompiled with CFR 0.152.
 */
package com.codika.androidmvp.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import com.codika.androidmvp.presenter.BasePresenter;
import com.codika.androidmvp.view.BaseView;

public abstract class BaseMvpFragment<V extends BaseView, P extends BasePresenter<V>>
extends Fragment
implements LoaderManager.LoaderCallbacks<P> {
    static final int PRESENTER_LOADER_ID = 1;
    private P presenter;

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)this);
    }

    public void onResume() {
        super.onResume();
        ((BasePresenter)this.presenter).onAttachView(this.getMvpView());
    }

    public void onPause() {
        super.onPause();
        ((BasePresenter)this.presenter).onDetachView();
    }

    public P getPresenter() {
        return this.presenter;
    }

    public abstract V getMvpView();

    public abstract Loader<P> getPresenterLoader();

    public Loader<P> onCreateLoader(int id, Bundle args) {
        return this.getPresenterLoader();
    }

    public void onLoadFinished(Loader<P> loader, P data) {
        this.presenter = data;
    }

    public void onLoaderReset(Loader<P> loader) {
        this.presenter = null;
    }
}

