/*
 * Decompiled with CFR 0.152.
 */
package com.codika.androidmvp.loader;

import android.content.Context;
import android.support.v4.content.Loader;
import com.codika.androidmvp.presenter.BasePresenter;

public abstract class PresenterLoader<T extends BasePresenter>
extends Loader<T> {
    private T presenter;

    public PresenterLoader(Context context) {
        super(context);
    }

    protected void onStartLoading() {
        super.onStartLoading();
        if (this.presenter != null) {
            this.deliverResult(this.presenter);
            return;
        }
        this.forceLoad();
    }

    protected void onForceLoad() {
        this.presenter = this.getPresenter();
        if (this.presenter == null) {
            throw new NullPointerException("Presenter is null! Do you return null in getPresenter()?");
        }
        this.deliverResult(this.presenter);
    }

    protected void onReset() {
        if (this.presenter != null) {
            ((BasePresenter)this.presenter).onDestroy();
            this.presenter = null;
        }
    }

    public abstract T getPresenter();
}

