/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.youtubethumbnailview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.codewaves.youtubethumbnailview.ImageLoader;
import com.codewaves.youtubethumbnailview.R;
import com.codewaves.youtubethumbnailview.ThumbnailLoader;
import com.codewaves.youtubethumbnailview.ThumbnailLoadingListener;
import com.codewaves.youtubethumbnailview.Utils;

public class ThumbnailView
extends RelativeLayout {
    private static final int DEFAULT_TITLE_MAX_LINES = 1;
    private static final int DEFAULT_MIN_THUMBNAIL_SIZE = 320;
    private static final int DEFAULT_FADE_DURATION = 500;
    private ImageView thumbnailView;
    private TextView titleView;
    private TextView timeView;
    private boolean isLoaded;
    private int minThumbnailSize;
    private boolean titleVisible;
    private boolean timeVisible;
    private int fadeDuration;

    private int dpToPx(Context context, float dp) {
        float scale = context.getResources().getDisplayMetrics().density;
        return Math.round(dp * scale);
    }

    public ThumbnailView(Context context) {
        this(context, null);
    }

    public ThumbnailView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ThumbnailView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public ThumbnailView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray attr = context.obtainStyledAttributes(attrs, R.styleable.ThumbnailView, 0, 0);
        this.minThumbnailSize = attr.getInteger(R.styleable.ThumbnailView_youtube_minThumbnailWidth, 320);
        this.fadeDuration = 500;
        this.titleVisible = attr.getBoolean(R.styleable.ThumbnailView_youtube_titleVisible, true);
        this.timeVisible = attr.getBoolean(R.styleable.ThumbnailView_youtube_timeVisible, true);
        int titleColor = attr.getColor(R.styleable.ThumbnailView_youtube_titleColor, -1);
        int titleBackgroundColor = attr.getColor(R.styleable.ThumbnailView_youtube_titleBackgroundColor, Integer.MIN_VALUE);
        int titlePaddingLeft = attr.getDimensionPixelSize(R.styleable.ThumbnailView_youtube_titlePaddingLeft, this.dpToPx(context, 10.0f));
        int titlePaddingRight = attr.getDimensionPixelSize(R.styleable.ThumbnailView_youtube_titlePaddingRight, this.dpToPx(context, 10.0f));
        int titlePaddingTop = attr.getDimensionPixelSize(R.styleable.ThumbnailView_youtube_titlePaddingTop, this.dpToPx(context, 5.0f));
        int titlePaddingBottom = attr.getDimensionPixelSize(R.styleable.ThumbnailView_youtube_titlePaddingBottom, this.dpToPx(context, 5.0f));
        float titleTextSize = attr.getDimension(R.styleable.ThumbnailView_youtube_titleTextSize, this.getResources().getDimension(R.dimen.title_text_size));
        int titleMaxLines = attr.getInteger(R.styleable.ThumbnailView_youtube_titleMaxLines, 1);
        int timeColor = attr.getColor(R.styleable.ThumbnailView_youtube_timeColor, -1);
        int timeBackgroundColor = attr.getColor(R.styleable.ThumbnailView_youtube_timeBackgroundColor, Integer.MIN_VALUE);
        int timePaddingLeft = attr.getDimensionPixelSize(R.styleable.ThumbnailView_youtube_timePaddingLeft, this.dpToPx(context, 5.0f));
        int timePaddingRight = attr.getDimensionPixelSize(R.styleable.ThumbnailView_youtube_timePaddingRight, this.dpToPx(context, 5.0f));
        int timePaddingTop = attr.getDimensionPixelSize(R.styleable.ThumbnailView_youtube_timePaddingTop, this.dpToPx(context, 0.0f));
        int timePaddingBottom = attr.getDimensionPixelSize(R.styleable.ThumbnailView_youtube_timePaddingBottom, this.dpToPx(context, 0.0f));
        int timeMarginBottom = attr.getDimensionPixelSize(R.styleable.ThumbnailView_youtube_timeMarginBottom, this.dpToPx(context, 10.0f));
        int timeMarginRight = attr.getDimensionPixelSize(R.styleable.ThumbnailView_youtube_timeMarginRight, this.dpToPx(context, 10.0f));
        float timeTextSize = attr.getDimension(R.styleable.ThumbnailView_youtube_timeTextSize, this.getResources().getDimension(R.dimen.time_text_size));
        attr.recycle();
        this.thumbnailView = new ImageView(context);
        this.thumbnailView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.thumbnailView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.addView((View)this.thumbnailView);
        this.titleView = new TextView(context);
        this.titleView.setTextColor(titleColor);
        this.titleView.setBackgroundColor(titleBackgroundColor);
        this.titleView.setTextSize(0, titleTextSize);
        this.titleView.setMaxLines(titleMaxLines);
        this.titleView.setEllipsize(TextUtils.TruncateAt.END);
        this.titleView.setPadding(titlePaddingLeft, titlePaddingTop, titlePaddingRight, titlePaddingBottom);
        this.titleView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        this.titleView.setVisibility(8);
        this.addView((View)this.titleView);
        this.timeView = new TextView(context);
        this.timeView.setTextColor(timeColor);
        this.timeView.setBackgroundColor(timeBackgroundColor);
        this.timeView.setTextSize(0, timeTextSize);
        this.timeView.setMaxLines(1);
        this.timeView.setPadding(timePaddingLeft, timePaddingTop, timePaddingRight, timePaddingBottom);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -2);
        lp.setMargins(0, 0, timeMarginRight, timeMarginBottom);
        lp.addRule(12);
        lp.addRule(11);
        this.timeView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.timeView.setVisibility(8);
        this.addView((View)this.timeView);
        this.setClickable(true);
        this.setFocusable(true);
    }

    public void setFadeDuration(int durationMillis) {
        this.fadeDuration = durationMillis;
    }

    @NonNull
    public TextView getTitleView() {
        return this.titleView;
    }

    @NonNull
    public TextView getTimeView() {
        return this.timeView;
    }

    @NonNull
    public ImageView getThumbnailView() {
        return this.thumbnailView;
    }

    public void clearThumbnail() {
        ThumbnailLoader.cancelThumbnailLoad(this);
        this.titleView.setVisibility(8);
        this.timeView.setVisibility(8);
        this.thumbnailView.setImageDrawable(null);
        this.isLoaded = false;
    }

    public void setTitleVisibility(boolean visible) {
        this.titleVisible = visible;
        if (this.isLoaded) {
            this.titleView.setVisibility(visible ? 0 : 8);
        }
    }

    public void setTimeVisibility(boolean visible) {
        this.timeVisible = visible;
        if (this.isLoaded) {
            this.timeView.setVisibility(visible ? 0 : 8);
        }
    }

    public void displayThumbnail(@Nullable String title, int length, @Nullable Bitmap bitmap) {
        ThumbnailLoader.cancelThumbnailLoad(this);
        this.setThumbnailAndShow(title, length, bitmap, null);
    }

    public void displayThumbnail(@Nullable String title, int length, @Nullable Drawable drawable) {
        ThumbnailLoader.cancelThumbnailLoad(this);
        this.setThumbnailAndShow(title, length, null, drawable);
    }

    public void loadThumbnail(@NonNull String url) {
        this.loadThumbnail(url, null, null);
    }

    public void loadThumbnail(@NonNull String url, @NonNull ThumbnailLoadingListener listener) {
        this.loadThumbnail(url, listener, null);
    }

    public void loadThumbnail(@NonNull String url, @Nullable ImageLoader imageLoader) {
        this.loadThumbnail(url, null, imageLoader);
    }

    public void loadThumbnail(@NonNull String url, @Nullable ThumbnailLoadingListener listener, @Nullable ImageLoader imageLoader) {
        ThumbnailLoader.loadThumbnail(this, url, this.minThumbnailSize, listener, imageLoader);
    }

    void setThumbnailAndShow(@Nullable String title, int length, @Nullable Bitmap bitmap, @Nullable Drawable drawable) {
        this.titleView.setText((CharSequence)title);
        if (this.titleVisible) {
            this.titleView.setVisibility(0);
        }
        this.timeView.setText((CharSequence)Utils.secondsToTime(length));
        if (this.timeVisible) {
            this.timeView.setVisibility(length > 0 ? 0 : 8);
        }
        if (bitmap != null) {
            this.thumbnailView.setImageBitmap(bitmap);
        } else if (drawable != null) {
            this.thumbnailView.setImageDrawable(drawable);
        }
        this.animateViews(length > 0);
        this.isLoaded = true;
    }

    void animateViews(boolean animateTime) {
        if (!this.isLoaded) {
            AlphaAnimation fade = new AlphaAnimation(0.0f, 1.0f);
            fade.setDuration((long)this.fadeDuration);
            fade.setInterpolator((Interpolator)new DecelerateInterpolator());
            if (this.titleVisible) {
                this.titleView.startAnimation((Animation)fade);
            }
            if (this.timeVisible && animateTime) {
                this.timeView.startAnimation((Animation)fade);
            }
            this.thumbnailView.startAnimation((Animation)fade);
        }
    }
}

