/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.youtubethumbnailview;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.LruCache;
import com.codewaves.youtubethumbnailview.ImageLoader;
import com.codewaves.youtubethumbnailview.SimpleImageLoader;
import com.codewaves.youtubethumbnailview.ThumbnailLoadingListener;
import com.codewaves.youtubethumbnailview.ThumbnailRequest;
import com.codewaves.youtubethumbnailview.ThumbnailView;
import com.codewaves.youtubethumbnailview.VideoInfo;
import com.codewaves.youtubethumbnailview.downloader.ApiVideoInfoDownloader;
import com.codewaves.youtubethumbnailview.downloader.VideoInfoDownloader;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThumbnailLoader {
    private static final int DEFAULT_THREAD_POOL_SIZE = 3;
    private static final int DEFAULT_INFO_CACHE_SIZE = 64;
    private ThreadPoolExecutor executor;
    private VideoInfoDownloader defaultInfoDownloader;
    private ImageLoader defaultImageLoader;
    private boolean isCacheEnabled = true;
    private LruCache<String, VideoInfo> infoCache = new LruCache(64);
    private WeakHashMap<ThumbnailView, ThumbnailRequest> requestMap;
    private static volatile ThumbnailLoader instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ThumbnailLoader initInstance(@Nullable Context context, @Nullable String googleApiKey) {
        if (instance != null) return instance;
        Class<ThumbnailLoader> clazz = ThumbnailLoader.class;
        synchronized (ThumbnailLoader.class) {
            if (instance != null) return instance;
            instance = new ThumbnailLoader(context, googleApiKey);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    public static ThumbnailLoader initialize(@NonNull Context context) {
        return ThumbnailLoader.initInstance(context, null);
    }

    public static ThumbnailLoader initialize(@NonNull String googleApiKey) {
        return ThumbnailLoader.initInstance(null, googleApiKey);
    }

    public static ThumbnailLoader initialize() {
        return ThumbnailLoader.initInstance(null, null);
    }

    public ThumbnailLoader setVideoInfoDownloader(@NonNull VideoInfoDownloader defaultInfoDownloader) {
        this.defaultInfoDownloader = defaultInfoDownloader;
        return this;
    }

    public ThumbnailLoader setImageLoader(@NonNull ImageLoader defaultImageLoader) {
        this.defaultImageLoader = defaultImageLoader;
        return this;
    }

    public ThumbnailLoader enableInfoCache(boolean enable) {
        this.isCacheEnabled = enable;
        return this;
    }

    private ThumbnailLoader(@Nullable Context context, @Nullable String googleApiKey) {
        String metaGoogleApiKey = googleApiKey;
        if (context != null) {
            try {
                ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                if (appInfo.metaData != null) {
                    metaGoogleApiKey = appInfo.metaData.getString("com.codewaves.youtubethumbnailview.ApiKey");
                }
            }
            catch (PackageManager.NameNotFoundException appInfo) {
                // empty catch block
            }
        }
        LinkedBlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>();
        this.executor = new ThreadPoolExecutor(3, 3, 0L, TimeUnit.MILLISECONDS, taskQueue);
        this.requestMap = new WeakHashMap();
        this.defaultInfoDownloader = new ApiVideoInfoDownloader(metaGoogleApiKey);
        this.defaultImageLoader = new SimpleImageLoader();
    }

    private void loadThumbnailInt(@NonNull ThumbnailView view, @NonNull String url, int minThumbnailSize, @Nullable ThumbnailLoadingListener listener, @Nullable ImageLoader imageLoader) {
        ThumbnailRequest existingRequest = this.requestMap.get((Object)view);
        if (existingRequest != null) {
            existingRequest.cancel();
            this.requestMap.remove((Object)view);
        }
        ThumbnailRequest request = new ThumbnailRequest(this.executor, view, url, minThumbnailSize, this.defaultInfoDownloader, imageLoader == null ? this.defaultImageLoader : imageLoader, listener, !this.isCacheEnabled);
        this.requestMap.put(view, request);
        request.run();
    }

    static void loadThumbnail(@NonNull ThumbnailView view, @NonNull String url, int minThumbnailSize, @Nullable ThumbnailLoadingListener listener, @Nullable ImageLoader imageLoader) {
        if (instance == null) {
            throw new IllegalStateException("Youtube thumbnail library is not initialized");
        }
        instance.loadThumbnailInt(view, url, minThumbnailSize, listener, imageLoader);
    }

    private void cancelThumbnailLoadInt(@NonNull ThumbnailView view) {
        ThumbnailRequest existingRequest = this.requestMap.get((Object)view);
        if (existingRequest != null) {
            existingRequest.cancel();
            this.requestMap.remove((Object)view);
        }
    }

    static void cancelThumbnailLoad(@NonNull ThumbnailView view) {
        instance.cancelThumbnailLoadInt(view);
    }

    static VideoInfo findInfoInCache(@NonNull String url) {
        if (instance == null) {
            throw new IllegalStateException("Youtube thumbnail library is not initialized");
        }
        return (VideoInfo)ThumbnailLoader.instance.infoCache.get((Object)url);
    }

    static void putInfoIntoCache(@NonNull String url, @NonNull VideoInfo info) {
        if (instance == null) {
            throw new IllegalStateException("Youtube thumbnail library is not initialized");
        }
        ThumbnailLoader.instance.infoCache.put((Object)url, (Object)info);
    }
}

