/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.youtubethumbnailview.downloader;

import android.support.annotation.NonNull;
import com.codewaves.youtubethumbnailview.VideoInfo;
import com.codewaves.youtubethumbnailview.downloader.VideoInfoDownloader;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URLEncoder;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OembedVideoInfoDownloader
implements VideoInfoDownloader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public VideoInfo download(@NonNull String url, int minThumbnailWidth) throws IOException {
        String encodedUrl = URLEncoder.encode(url, "UTF-8");
        String ombedUrl = "http://www.youtube.com/oembed?url=" + encodedUrl + "&format=json";
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(ombedUrl).build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            Gson gson = new Gson();
            OembedResponse result = (OembedResponse)gson.fromJson(response.body().charStream(), OembedResponse.class);
            if (result.title == null && result.thumbnail_url == null) {
                throw new IOException("Invalid youtube oembed response.");
            }
            VideoInfo videoInfo = new VideoInfo(result.title, result.thumbnail_url, 0);
            return videoInfo;
        }
    }

    private static class OembedResponse {
        String title;
        String thumbnail_url;

        private OembedResponse() {
        }
    }
}

