/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.youtubethumbnailview;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    private static final int HOUR_SECONDS = 3600;
    private static final int MINUTE_SECONDS = 60;
    private static final String TIME_DELIMITER = ":";
    private static final String TIME_PADDING = "0";
    private static final String REGEXP_ID_PATTERN = "(?i)https?:\\/\\/(?:[0-9A-Z-]+\\.)?(?:youtu\\.be\\/|youtube(?:-nocookie)?\\.com\\S*?[^\\w\\s-])([\\w-]{11})(?=[^\\w-]|$)(?![?=&+%\\w.-]*(?:['\"][^<>]*>|<\\/a>))[?=&+%\\w.-]*";

    public static int durationToSeconds(@Nullable String duration) {
        if (duration == null || duration.length() <= 0) {
            return 0;
        }
        int current = 0;
        int seconds = 0;
        for (char c : duration.toCharArray()) {
            if (Character.isDigit(c)) {
                current = current * 10 + Character.getNumericValue(c);
                continue;
            }
            if (c == 'H') {
                seconds += current * 3600;
                current = 0;
                continue;
            }
            if (c == 'M') {
                seconds += current * 60;
                current = 0;
                continue;
            }
            if (c != 'S') continue;
            seconds += current;
            current = 0;
        }
        return seconds;
    }

    public static String getVideoIdFromUrl(@NonNull String url) {
        Pattern pattern = Pattern.compile(REGEXP_ID_PATTERN);
        Matcher matcher = pattern.matcher(url);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Cannot extract video id from url");
    }

    @NonNull
    public static String secondsToTime(int totalSeconds) {
        int hours = totalSeconds / 3600;
        int minutes = (totalSeconds - hours * 3600) / 60;
        int seconds = totalSeconds - hours * 3600 - minutes * 60;
        String timeString = "";
        if (hours > 0) {
            timeString = timeString + String.valueOf(hours) + TIME_DELIMITER;
        }
        timeString = minutes < 10 ? timeString + TIME_PADDING + String.valueOf(minutes) + TIME_DELIMITER : timeString + String.valueOf(minutes) + TIME_DELIMITER;
        timeString = seconds < 10 ? timeString + TIME_PADDING + String.valueOf(seconds) : timeString + String.valueOf(seconds);
        return timeString;
    }
}

