/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.youtubethumbnailview;

import android.graphics.Bitmap;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.codewaves.youtubethumbnailview.CancellableTask;
import com.codewaves.youtubethumbnailview.ImageLoader;
import com.codewaves.youtubethumbnailview.ThumbnailDownloadListener;
import com.codewaves.youtubethumbnailview.ThumbnailLoadingListener;
import com.codewaves.youtubethumbnailview.ThumbnailTask;
import com.codewaves.youtubethumbnailview.ThumbnailView;
import com.codewaves.youtubethumbnailview.VideoInfo;
import com.codewaves.youtubethumbnailview.downloader.VideoInfoDownloader;
import java.util.concurrent.ThreadPoolExecutor;

class ThumbnailRequest
extends CancellableTask {
    private final ThreadPoolExecutor executor;
    private final ThumbnailView view;
    private final String url;
    private final int minThumbnailSize;
    private final VideoInfoDownloader infoDownloader;
    private final ThumbnailLoadingListener listener;
    private final ImageLoader imageLoader;
    private ThumbnailTask task;

    ThumbnailRequest(@NonNull ThreadPoolExecutor executor, @NonNull ThumbnailView view, @NonNull String url, int minThumbnailSize, @NonNull VideoInfoDownloader infoDownloader, @NonNull ImageLoader imageLoader, @Nullable ThumbnailLoadingListener listener) {
        this.executor = executor;
        this.view = view;
        this.url = url;
        this.minThumbnailSize = minThumbnailSize;
        this.infoDownloader = infoDownloader;
        this.listener = listener;
        this.imageLoader = imageLoader;
    }

    @Override
    public void run() {
        if (this.listener != null) {
            this.listener.onLoadingStarted(this.url, (View)this.view);
        }
        Handler handler = new Handler();
        this.task = new ThumbnailTask(this.url, this.minThumbnailSize, this.infoDownloader, this.imageLoader, new ThumbnailDownloadListener(){

            @Override
            public void onDownloadFinished(@NonNull VideoInfo info, @Nullable Bitmap bitmap) {
                if (!ThumbnailRequest.this.isCanceled()) {
                    ThumbnailRequest.this.view.setThumbnailAndShow(info.getTitle(), info.getLength(), bitmap, null);
                    ThumbnailRequest.this.finish();
                    if (ThumbnailRequest.this.listener != null) {
                        ThumbnailRequest.this.listener.onLoadingComplete(ThumbnailRequest.this.url, (View)ThumbnailRequest.this.view);
                    }
                }
            }

            @Override
            public void onDownloadFailed(@NonNull Throwable error) {
                if (!ThumbnailRequest.this.isCanceled()) {
                    ThumbnailRequest.this.finish();
                    if (ThumbnailRequest.this.listener != null) {
                        ThumbnailRequest.this.listener.onLoadingFailed(ThumbnailRequest.this.url, (View)ThumbnailRequest.this.view, error);
                    }
                }
            }
        }, handler);
        this.executor.execute(this.task);
    }

    @Override
    public void onCancel() {
        this.executor.remove(this.task);
        if (this.listener != null) {
            this.listener.onLoadingCanceled(this.url, (View)this.view);
        }
    }
}

