/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.token;

import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.EquPart;
import com.codetaco.math.impl.Function;
import com.codetaco.math.impl.ValueStack;
import com.codetaco.math.impl.token.TokOperand;
import com.codetaco.math.impl.token.TokVariableWithValue;

public class TokVariable
extends TokOperand {
    private boolean assignedByEquation = false;

    public TokVariable(EquImpl equ) {
        super(equ);
    }

    @Override
    public boolean accepts(char s) {
        return Character.isLetter(s) || Character.isDigit(s) || s == '_' || s == '.';
    }

    public String getName() {
        return super.toString();
    }

    public boolean isResetable() {
        return this.assignedByEquation;
    }

    @Override
    public EquPart morph() {
        Function fun = this.getEqu().function(this);
        if (fun == null) {
            return this;
        }
        return fun;
    }

    @Override
    public void resolve(ValueStack values) throws Exception {
        if (this.getEqu().getSupport() == null) {
            throw new Exception("variables require support");
        }
        Object obj = this.getEqu().getSupport().resolveVariable(this.getValue().toString().toLowerCase(), this.getEqu().getBaseDate());
        if (obj == null) {
            values.push(this);
            this.assignedByEquation = true;
        } else {
            TokVariableWithValue twv = new TokVariableWithValue(this.getEqu());
            twv.setVariable(this);
            twv.setCurrentValue(obj);
            values.push(twv);
        }
    }

    @Override
    public String toString() {
        return "var(" + super.toString() + ")";
    }
}

