/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.token;

import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.EquPart;
import com.codetaco.math.impl.Operator;
import com.codetaco.math.impl.ValueStack;
import com.codetaco.math.impl.token.TokOperand;

public class TokNumber
extends TokOperand {
    public TokNumber(EquImpl equ) {
        super(equ);
    }

    @Override
    public boolean accepts(char s, char peek) {
        if (Character.isDigit(s) || s == '.') {
            return true;
        }
        if (this.getValue().length() == 0) {
            return false;
        }
        if (s == '=') {
            return this.getValue().length() == 1 && this.getValue().charAt(0) == '-';
        }
        char prevChar = this.getValue().charAt(this.getValue().length() - 1);
        if (s == '-') {
            return this.getValue().length() > 1 && (prevChar == 'e' || prevChar == 'E');
        }
        if (s == 'e' || s == 'E') {
            if (this.getValue().indexOf("e") > -1 || this.getValue().indexOf("E") > -1) {
                return false;
            }
            return Character.isDigit(prevChar) && (Character.isDigit(peek) || peek == '-');
        }
        return false;
    }

    @Override
    public EquPart morph() {
        Operator part;
        if (this.getValue().length() == 1 && this.getValue().charAt(0) == '-' && (part = this.getEqu().operator(this)) != null) {
            return part;
        }
        if (this.getValue().length() == 2 && this.getValue().charAt(0) == '-' && this.getValue().charAt(1) == '=' && (part = this.getEqu().operator(this)) != null) {
            return part;
        }
        return this;
    }

    @Override
    public void resolve(ValueStack values) throws Exception {
        String valueToBeParsed = this.getValue().toString();
        if (valueToBeParsed.indexOf(46) == -1 && valueToBeParsed.indexOf(101) == -1 && valueToBeParsed.indexOf(69) == -1) {
            values.push(new Long(valueToBeParsed));
        } else {
            values.push(new Double(valueToBeParsed));
        }
    }

    @Override
    public String toString() {
        return "num(" + super.toString() + ")";
    }
}

