/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.function;

import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.Function;
import com.codetaco.math.impl.ValueStack;
import com.codetaco.math.impl.token.TokVariable;
import java.text.ParseException;

public class FuncTan
extends Function {
    public FuncTan(EquImpl equ) {
        super(equ);
    }

    public FuncTan(EquImpl equ, TokVariable var) {
        super(equ, var);
    }

    @Override
    public void resolve(ValueStack values) throws Exception {
        if (values.size() < 1) {
            throw new Exception("missing operands for " + this.toString());
        }
        try {
            double degrees = values.popDouble();
            double rads = degrees * (Math.PI / 180);
            values.push(new Double(Math.tan(rads)));
        }
        catch (ParseException e) {
            e.fillInStackTrace();
            throw new Exception(this.toString() + "; " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "function(tan)";
    }
}

