/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.function;

import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.Function;
import com.codetaco.math.impl.ValueStack;
import com.codetaco.math.impl.token.TokVariable;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FuncStringMatch
extends Function {
    private void pushAppropriateType(ValueStack values, Object whoKnowsWhat, String result) {
        if (whoKnowsWhat instanceof String) {
            values.push(result);
        } else if (whoKnowsWhat instanceof byte[]) {
            values.push(result.getBytes(StandardCharsets.ISO_8859_1));
        }
    }

    public FuncStringMatch(EquImpl equ) {
        super(equ);
    }

    public FuncStringMatch(EquImpl equ, TokVariable var) {
        super(equ, var);
    }

    @Override
    public void resolve(ValueStack values) throws Exception {
        if (values.size() < this.getParameterCount()) {
            throw new Exception("missing operands for " + this.toString());
        }
        try {
            int groupNumber = 0;
            if (this.getParameterCount() == 3) {
                groupNumber = (int)values.popLong();
            }
            String pattern = values.popString();
            Object whoKnowsWhat = values.popStringOrByteArray();
            String target = whoKnowsWhat instanceof String ? (String)whoKnowsWhat : ValueStack.byteArrayAsString(whoKnowsWhat);
            Matcher matcher = Pattern.compile(pattern).matcher(target);
            if (matcher.find()) {
                this.pushAppropriateType(values, whoKnowsWhat, matcher.group(groupNumber));
            } else {
                this.pushAppropriateType(values, whoKnowsWhat, "");
            }
        }
        catch (ParseException e) {
            e.fillInStackTrace();
            throw new Exception(this.toString() + "; " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "function(match-" + this.getParameterCount() + ")";
    }
}

