/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.axmlrpc.serializer;

import de.timroes.axmlrpc.XMLRPCException;
import de.timroes.axmlrpc.XMLUtil;
import de.timroes.axmlrpc.serializer.Serializer;
import de.timroes.axmlrpc.xmlcreator.XmlElement;
import fr.turri.jiso8601.Iso8601Deserializer;
import java.text.SimpleDateFormat;
import org.w3c.dom.Element;

public class DateTimeSerializer
implements Serializer {
    private static final String DATETIME_FORMAT = "yyyyMMdd'T'HHmmss";
    private final SimpleDateFormat DATE_FORMATER = new SimpleDateFormat("yyyyMMdd'T'HHmmss");

    @Override
    public Object deserialize(Element content) throws XMLRPCException {
        return this.deserialize(XMLUtil.getOnlyTextContent(content.getChildNodes()));
    }

    public Object deserialize(String dateStr) throws XMLRPCException {
        try {
            return Iso8601Deserializer.toDate((String)dateStr);
        }
        catch (Exception ex) {
            throw new XMLRPCException("Unable to parse given date.", ex);
        }
    }

    @Override
    public XmlElement serialize(Object object) {
        return XMLUtil.makeXmlTag("dateTime.iso8601", this.DATE_FORMATER.format(object));
    }
}

