/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.axmlrpc;

import de.timroes.axmlrpc.XMLRPCException;
import de.timroes.axmlrpc.XMLRPCServerException;
import de.timroes.axmlrpc.XMLUtil;
import de.timroes.axmlrpc.serializer.SerializerHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ResponseParser {
    private static final String FAULT_CODE = "faultCode";
    private static final String FAULT_STRING = "faultString";

    ResponseParser() {
    }

    public Object parse(InputStream response, boolean debugMode) throws XMLRPCException {
        try {
            Element e;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document dom = builder.parse(response);
            if (debugMode) {
                ResponseParser.printDocument(dom, System.out);
            }
            if (!(e = dom.getDocumentElement()).getNodeName().equals("methodResponse")) {
                throw new XMLRPCException("MethodResponse root tag is missing.");
            }
            if ((e = XMLUtil.getOnlyChildElement(e.getChildNodes())).getNodeName().equals("params")) {
                if (!(e = XMLUtil.getOnlyChildElement(e.getChildNodes())).getNodeName().equals("param")) {
                    throw new XMLRPCException("The params tag must contain a param tag.");
                }
                return this.getReturnValueFromElement(e);
            }
            if (e.getNodeName().equals("fault")) {
                Map o = (Map)this.getReturnValueFromElement(e);
                throw new XMLRPCServerException((String)o.get(FAULT_STRING), (Integer)o.get(FAULT_CODE));
            }
            throw new XMLRPCException("The methodResponse tag must contain a fault or params tag.");
        }
        catch (XMLRPCServerException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new XMLRPCException("Error getting result from server.", ex);
        }
    }

    public static void printDocument(Document doc, OutputStream out) throws IOException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(out, "UTF-8")));
    }

    private Object getReturnValueFromElement(Element element) throws XMLRPCException {
        Element childElement = XMLUtil.getOnlyChildElement(element.getChildNodes());
        return SerializerHandler.getDefault().deserialize(childElement);
    }
}

