/*
 * Decompiled with CFR 0.152.
 */
package com.codersun.fingerprintcompat;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

@RequiresApi(api=23)
class CipherHelper {
    private static CipherHelper instance;
    private static final String DEFAULT_KEY_NAME = "defaultKey";
    private static final String KEYSTORE_ALIAS = "keyStoreAlias";
    private static final String HAS_FINGER_KEY = "hasFingerKey";
    private KeyGenerator mKeyGenerator;
    private KeyStore keyStore;

    private CipherHelper() {
        try {
            this.keyStore = KeyStore.getInstance("AndroidKeyStore");
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        try {
            this.mKeyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException("Failed to get an instance of KeyGenerator", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static CipherHelper getInstance() {
        if (instance != null) return instance;
        Class<CipherHelper> clazz = CipherHelper.class;
        synchronized (CipherHelper.class) {
            if (instance != null) return instance;
            instance = new CipherHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    Cipher createCipher() {
        try {
            return Cipher.getInstance("AES/CBC/PKCS7Padding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
    }

    boolean initCipher(Cipher cipher) {
        try {
            this.keyStore.load(null);
            SecretKey key = (SecretKey)this.keyStore.getKey(KEYSTORE_ALIAS, null);
            if (cipher == null) {
                cipher = this.createCipher();
            }
            cipher.init(1, key);
            return false;
        }
        catch (KeyPermanentlyInvalidatedException e) {
            return true;
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException("Failed to init Cipher", e);
        }
    }

    void createKey(Context context, boolean createNewKey) {
        if (context == null) {
            throw new RuntimeException("context can not be null");
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences(DEFAULT_KEY_NAME, 0);
        try {
            if (TextUtils.isEmpty((CharSequence)sharedPreferences.getString(HAS_FINGER_KEY, "")) || createNewKey) {
                KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(KEYSTORE_ALIAS, 3).setBlockModes(new String[]{"CBC"}).setUserAuthenticationRequired(true).setEncryptionPaddings(new String[]{"PKCS7Padding"});
                if (Build.VERSION.SDK_INT >= 24) {
                    builder.setInvalidatedByBiometricEnrollment(true);
                }
                this.mKeyGenerator.init((AlgorithmParameterSpec)builder.build());
                this.mKeyGenerator.generateKey();
                sharedPreferences.edit().putString(HAS_FINGER_KEY, "KEY").apply();
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
    }
}

