/*
 * Decompiled with CFR 0.152.
 */
package com.codersun.fingerprintcompat;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

class SharePreferenceUtil {
    private static final String DEFAULT_NAME = "finger";
    public static String KEY_IS_FINGER_CHANGE = "is_finger_change";

    SharePreferenceUtil() {
    }

    private static SharedPreferences.Editor getSharePreferenceEditor(Context context, String fileName) {
        return SharePreferenceUtil.getSharedPreferences(context, fileName).edit();
    }

    private static SharedPreferences getSharedPreferences(Context context, String fileName) {
        return context.getSharedPreferences(TextUtils.isEmpty((CharSequence)fileName) ? DEFAULT_NAME : fileName, 0);
    }

    public static void saveData(Context context, String key, String value) {
        SharePreferenceUtil.saveData(context, key, value, null);
    }

    public static void saveData(Context context, String key, String value, String fileName) {
        SharedPreferences.Editor editor = SharePreferenceUtil.getSharePreferenceEditor(context, fileName);
        editor.putString(key, value);
        editor.commit();
    }

    public static String getValue(Context context, String key) {
        if (null == key) {
            return "";
        }
        SharedPreferences sharedPreferences = SharePreferenceUtil.getSharedPreferences(context, "");
        return sharedPreferences.getString(key, "");
    }

    public static boolean isFingerDataChange(Context context) {
        String value = SharePreferenceUtil.getValue(context, KEY_IS_FINGER_CHANGE);
        boolean result = false;
        result = TextUtils.isEmpty((CharSequence)value) ? false : Integer.parseInt(value) == 1;
        return result;
    }
}

