/*
 * Decompiled with CFR 0.152.
 */
package com.codersun.fingerprintcompat;

import android.app.Activity;
import android.content.Context;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Build;
import android.os.CancellationSignal;
import android.support.annotation.RequiresApi;
import android.support.v4.hardware.fingerprint.FingerprintManagerCompat;
import com.codersun.fingerprintcompat.AFingerDialog;
import com.codersun.fingerprintcompat.BiometricPromptImpl23;
import com.codersun.fingerprintcompat.BiometricPromptImpl28;
import com.codersun.fingerprintcompat.CipherHelper;
import com.codersun.fingerprintcompat.FingerManagerController;
import com.codersun.fingerprintcompat.IBiometricPromptImpl;

@RequiresApi(api=23)
public class FingerManager {
    private static FingerManager fingerManager;
    private static FingerManagerController mFingerManagerController;
    private CancellationSignal cancellationSignal;
    private IBiometricPromptImpl biometricPrompt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static FingerManager getInstance() {
        if (fingerManager != null) return fingerManager;
        Class<FingerManager> clazz = FingerManager.class;
        synchronized (FingerManager.class) {
            if (fingerManager != null) return fingerManager;
            fingerManager = new FingerManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return fingerManager;
        }
    }

    static FingerManager getInstance(FingerManagerController fingerManagerController) {
        mFingerManagerController = fingerManagerController;
        return FingerManager.getInstance();
    }

    private FingerManager() {
    }

    private void createImp(Activity activity, AFingerDialog fingerDialog) {
        if (Build.VERSION.SDK_INT >= 28) {
            this.biometricPrompt = new BiometricPromptImpl28(activity, mFingerManagerController);
        } else if (Build.VERSION.SDK_INT >= 23) {
            this.biometricPrompt = new BiometricPromptImpl23(activity, fingerDialog, mFingerManagerController);
        }
    }

    public static SupportResult checkSupport(Context context) {
        FingerprintManager fingerprintManager = (FingerprintManager)context.getSystemService(FingerprintManager.class);
        if (fingerprintManager.isHardwareDetected()) {
            if (fingerprintManager.hasEnrolledFingerprints()) {
                return SupportResult.SUPPORT;
            }
            return SupportResult.SUPPORT_WITHOUT_DATA;
        }
        return SupportResult.DEVICE_UNSUPPORTED;
    }

    public static boolean hasFingerprintData(Context context) {
        FingerprintManagerCompat fingerprintManagerCompat = FingerprintManagerCompat.from((Context)context);
        return fingerprintManagerCompat.hasEnrolledFingerprints();
    }

    @RequiresApi(api=23)
    private void startListener() {
        CipherHelper.getInstance().createKey((Context)mFingerManagerController.getApplication(), false);
        if (this.cancellationSignal == null) {
            this.cancellationSignal = new CancellationSignal();
        }
        if (this.cancellationSignal.isCanceled()) {
            this.cancellationSignal = new CancellationSignal();
        }
        this.biometricPrompt.authenticate(this.cancellationSignal);
    }

    public void startListener(Activity activity) {
        this.createImp(activity, mFingerManagerController.getFingerDialogApi23());
        this.startListener();
    }

    public static void updateFingerData(Context context) {
        CipherHelper.getInstance().createKey(context, true);
    }

    public static FingerManagerController build() {
        return new FingerManagerController();
    }

    public static enum SupportResult {
        DEVICE_UNSUPPORTED,
        SUPPORT_WITHOUT_DATA,
        SUPPORT;

    }
}

