/*
 * Decompiled with CFR 0.152.
 */
package com.codersun.fingerprintcompat;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.hardware.biometrics.BiometricPrompt;
import android.os.CancellationSignal;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import com.codersun.fingerprintcompat.AonFingerChangeCallback;
import com.codersun.fingerprintcompat.CipherHelper;
import com.codersun.fingerprintcompat.FingerManagerController;
import com.codersun.fingerprintcompat.IBiometricPromptImpl;
import com.codersun.fingerprintcompat.IonFingerCallback;
import com.codersun.fingerprintcompat.SharePreferenceUtil;
import javax.crypto.Cipher;

@RequiresApi(value=28)
public class BiometricPromptImpl28
implements IBiometricPromptImpl {
    private Activity mActivity;
    private BiometricPrompt mBiometricPrompt;
    private CancellationSignal mCancellationSignal;
    private Cipher cipher;
    private IonFingerCallback mCallback;
    private boolean userCancel;
    private AonFingerChangeCallback mFingerChangeCallback;

    @RequiresApi(value=28)
    BiometricPromptImpl28(Activity activity, FingerManagerController fingerManagerController) {
        this.mActivity = activity;
        this.mCallback = fingerManagerController.getFingerCheckCallback();
        this.mFingerChangeCallback = fingerManagerController.getFingerChangeCallback();
        this.mBiometricPrompt = new BiometricPrompt.Builder((Context)activity).setTitle((CharSequence)fingerManagerController.getTitle()).setDescription((CharSequence)fingerManagerController.getDes()).setNegativeButton((CharSequence)fingerManagerController.getNegativeText(), activity.getMainExecutor(), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                BiometricPromptImpl28.this.mCallback.onCancel();
                BiometricPromptImpl28.this.userCancel = true;
                BiometricPromptImpl28.this.mCancellationSignal.cancel();
            }
        }).build();
        this.cipher = CipherHelper.getInstance().createCipher();
    }

    @Override
    @RequiresApi(value=28)
    public void authenticate(@Nullable CancellationSignal cancel) {
        this.userCancel = false;
        this.mCancellationSignal = cancel;
        if (CipherHelper.getInstance().initCipher(this.cipher) || SharePreferenceUtil.isFingerDataChange((Context)this.mActivity)) {
            this.mFingerChangeCallback.onChange((Context)this.mActivity);
            return;
        }
        this.mBiometricPrompt.authenticate(new BiometricPrompt.CryptoObject(this.cipher), this.mCancellationSignal, this.mActivity.getMainExecutor(), (BiometricPrompt.AuthenticationCallback)new BiometricPromptCallbackImpl());
    }

    @RequiresApi(value=28)
    private class BiometricPromptCallbackImpl
    extends BiometricPrompt.AuthenticationCallback {
        private BiometricPromptCallbackImpl() {
        }

        public void onAuthenticationError(int errorCode, CharSequence errString) {
            super.onAuthenticationError(errorCode, errString);
            BiometricPromptImpl28.this.mCancellationSignal.cancel();
            if (!BiometricPromptImpl28.this.userCancel) {
                BiometricPromptImpl28.this.mCallback.onError(errString.toString());
            }
        }

        public void onAuthenticationHelp(int helpCode, CharSequence helpString) {
            super.onAuthenticationHelp(helpCode, helpString);
        }

        public void onAuthenticationSucceeded(BiometricPrompt.AuthenticationResult result) {
            super.onAuthenticationSucceeded(result);
            BiometricPromptImpl28.this.mCancellationSignal.cancel();
            BiometricPromptImpl28.this.mCallback.onSucceed();
        }

        public void onAuthenticationFailed() {
            super.onAuthenticationFailed();
            BiometricPromptImpl28.this.mCallback.onFailed();
        }
    }
}

