/*
 * Decompiled with CFR 0.152.
 */
package com.codersun.fingerprintcompat;

import android.app.Activity;
import android.content.Context;
import android.hardware.fingerprint.FingerprintManager;
import android.os.CancellationSignal;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.codersun.fingerprintcompat.AFingerDialog;
import com.codersun.fingerprintcompat.AonFingerChangeCallback;
import com.codersun.fingerprintcompat.CipherHelper;
import com.codersun.fingerprintcompat.DefaultFingerDialog;
import com.codersun.fingerprintcompat.FingerManagerController;
import com.codersun.fingerprintcompat.IBiometricPromptImpl;
import com.codersun.fingerprintcompat.IonFingerCallback;
import com.codersun.fingerprintcompat.SharePreferenceUtil;
import javax.crypto.Cipher;

@RequiresApi(api=23)
public class BiometricPromptImpl23
implements IBiometricPromptImpl {
    private Cipher mCipher;
    private Activity mActivity;
    private boolean mSelfCanceled;
    private AFingerDialog mFingerDialog;
    private IonFingerCallback mCallback;
    private AonFingerChangeCallback mFingerChangeCallback;
    private FingerManagerController mFingerManagerController;

    BiometricPromptImpl23(Activity activity, AFingerDialog fingerDialog, FingerManagerController fingerManagerController) {
        this.mActivity = activity;
        this.mFingerManagerController = fingerManagerController;
        this.mCipher = CipherHelper.getInstance().createCipher();
        this.mFingerChangeCallback = fingerManagerController.getFingerChangeCallback();
        this.mFingerDialog = fingerDialog == null ? DefaultFingerDialog.newInstance(fingerManagerController) : fingerDialog;
    }

    @Override
    public void authenticate(final @NonNull CancellationSignal cancel) {
        this.mCallback = this.mFingerManagerController.getFingerCheckCallback();
        this.mSelfCanceled = false;
        if (CipherHelper.getInstance().initCipher(this.mCipher) || SharePreferenceUtil.isFingerDataChange((Context)this.mActivity)) {
            this.mFingerChangeCallback.onChange((Context)this.mActivity);
            return;
        }
        this.mFingerDialog.setOnDismissListener(new AFingerDialog.IonDismissListener(){

            @Override
            public void onDismiss() {
                BiometricPromptImpl23.this.mSelfCanceled = !cancel.isCanceled();
                if (BiometricPromptImpl23.this.mSelfCanceled) {
                    cancel.cancel();
                    if (((Object)((Object)BiometricPromptImpl23.this.mFingerDialog)).getClass() == DefaultFingerDialog.class) {
                        BiometricPromptImpl23.this.mCallback.onCancel();
                    }
                }
            }
        });
        if (!this.mFingerDialog.isAdded()) {
            this.mFingerDialog.show(this.mActivity.getFragmentManager(), ((Object)((Object)this.mFingerDialog)).getClass().getSimpleName());
        }
        FingerprintManager fingerprintManager = (FingerprintManager)this.mActivity.getSystemService(FingerprintManager.class);
        fingerprintManager.authenticate(new FingerprintManager.CryptoObject(this.mCipher), cancel, 0, new FingerprintManager.AuthenticationCallback(){

            public void onAuthenticationError(int errMsgId, CharSequence errString) {
                super.onAuthenticationError(errMsgId, errString);
                if (!BiometricPromptImpl23.this.mSelfCanceled) {
                    cancel.cancel();
                    BiometricPromptImpl23.this.mFingerDialog.onError(errString.toString());
                    BiometricPromptImpl23.this.mCallback.onError(errString.toString());
                }
            }

            public void onAuthenticationHelp(int helpMsgId, CharSequence helpString) {
                super.onAuthenticationHelp(helpMsgId, helpString);
                BiometricPromptImpl23.this.mFingerDialog.onHelp(helpString.toString());
                BiometricPromptImpl23.this.mCallback.onHelp(helpString.toString());
            }

            public void onAuthenticationSucceeded(FingerprintManager.AuthenticationResult result) {
                super.onAuthenticationSucceeded(result);
                Cipher cipher = result.getCryptoObject().getCipher();
                if (cipher != null) {
                    try {
                        byte[] bytes = cipher.doFinal();
                        cancel.cancel();
                        BiometricPromptImpl23.this.mFingerDialog.onSucceed();
                        BiometricPromptImpl23.this.mCallback.onSucceed();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        BiometricPromptImpl23.this.mFingerChangeCallback.onChange((Context)BiometricPromptImpl23.this.mActivity);
                    }
                }
            }

            public void onAuthenticationFailed() {
                super.onAuthenticationFailed();
                BiometricPromptImpl23.this.mFingerDialog.onFailed();
                BiometricPromptImpl23.this.mCallback.onFailed();
            }
        }, null);
    }
}

