/*
 * Decompiled with CFR 0.152.
 */
package com.coderconsole.cextracter.cquery;

import android.content.Context;
import com.coderconsole.cextracter.common.permissions.PermissionWrapper;
import com.coderconsole.cextracter.cquery.base.CList;
import com.coderconsole.cextracter.cquery.base.CListExtractorAbstract;
import com.coderconsole.cextracter.i.IContact;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiConsumer;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;

public class CQuery {
    private static final String TAG = CQuery.class.getSimpleName();
    private static CQuery cQuery;
    private final Context mContext;
    private String limit;
    private String skip;
    private String orderBy;
    private int mListFilterType;
    private List<Disposable> mDisposable = new ArrayList<Disposable>();

    private CQuery(Context context) {
        this.mContext = context;
    }

    public static CQuery getInstance(Context context) {
        if (cQuery == null) {
            cQuery = new CQuery(context);
        }
        return cQuery;
    }

    public CQuery limit(String limit) {
        this.limit = limit;
        return this;
    }

    public CQuery skip(String skip) {
        this.skip = skip;
        return this;
    }

    public CQuery orderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public Disposable build(final IContact iContact) {
        if (!PermissionWrapper.hasContactsPermissions(this.mContext)) {
            throw new SecurityException("Contact Permission Missing");
        }
        return new CListExtractorAbstract(this.mContext).getList(this.mListFilterType, this.orderBy, this.limit, this.skip).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((BiConsumer)new BiConsumer<List<CList>, Throwable>(){

            public void accept(List<CList> genericCLists, Throwable throwable) throws Exception {
                if (iContact == null) {
                    return;
                }
                if (throwable == null) {
                    iContact.onContactSuccess(genericCLists);
                } else {
                    iContact.onContactError(throwable);
                }
            }
        });
    }

    public CQuery filter(int type) {
        this.mListFilterType = type;
        return this;
    }
}

